/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ValueIterator
implements Iterator<Float> {
    private float start;
    private float end;
    private float step;
    private int nextIndex = 0;
    private Float next;

    public ValueIterator(float start, float end, float step) {
        this.start = start;
        this.end = end;
        this.step = step;
        if (step == 0.0f) {
            throw new RuntimeException("Step cannot be 0");
        }
        this.reset();
    }

    public void reset() {
        this.nextIndex = 0;
        this.next = this.step > 0.0f && this.start <= this.end || this.step < 0.0f && this.start >= this.end ? Float.valueOf(this.start) : null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Float next() {
        if (this.next == null) {
            throw new NoSuchElementException("End of range");
        }
        float result = this.next.floatValue();
        ++this.nextIndex;
        this.next = Float.valueOf(this.start + (float)this.nextIndex * this.step);
        if (this.step > 0.0f && this.next.floatValue() > this.end || this.step < 0.0f && this.next.floatValue() < this.end) {
            this.next = null;
        }
        return Float.valueOf(result);
    }
}

