/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.beans;

import eu.woolplatform.utils.beans.PropertySpec;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class PropertyScanner {
    public static PropertySpec getProperty(Class<?> clazz, String name) {
        Field field;
        try {
            field = PropertyScanner.findDeclaredField(clazz, name);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(String.format("Can't find property \"%s\" in class %s", name, clazz.getName()));
        }
        PropertySpec spec = new PropertySpec();
        spec.setName(field.getName());
        spec.setField(field);
        spec.setPublic((field.getModifiers() & 1) != 0);
        if (!spec.isPublic()) {
            String capName = spec.getName().substring(0, 1).toUpperCase() + spec.getName().substring(1);
            ArrayList<String> getNames = new ArrayList<String>();
            if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                if (spec.getName().matches("is[A-Z0-9_].*")) {
                    getNames.add(spec.getName());
                }
                getNames.add("is" + capName);
            }
            getNames.add("get" + capName);
            StringBuilder logGets = new StringBuilder();
            for (int i = 0; i < getNames.size(); ++i) {
                if (i > 0 && i == getNames.size() - 1) {
                    logGets.append(" or ");
                } else if (i > 0) {
                    logGets.append(", ");
                }
                logGets.append("\"" + (String)getNames.get(i) + "\"");
            }
            NoSuchMethodException getMethodEx = null;
            for (String getName : getNames) {
                try {
                    spec.setGetMethod(PropertyScanner.findMethod(clazz, getName, new Class[0]));
                    break;
                }
                catch (NoSuchMethodException ex) {
                    if (getMethodEx != null) continue;
                    getMethodEx = ex;
                }
            }
            if (spec.getGetMethod() == null) {
                throw new RuntimeException(String.format("Can't read property \"%s\" in class %s: Field is not public and method %s not found", spec.getName(), clazz.getName(), logGets.toString()) + ": " + getMethodEx.getMessage(), getMethodEx);
            }
            ArrayList<String> setNames = new ArrayList<String>();
            if ((field.getType() == Boolean.TYPE || field.getType() == Boolean.class) && spec.getName().matches("is[A-Z0-9_].*")) {
                setNames.add("set" + spec.getName().substring(2));
            }
            setNames.add("set" + capName);
            StringBuilder logSets = new StringBuilder();
            for (int i = 0; i < setNames.size(); ++i) {
                if (i > 0 && i == setNames.size() - 1) {
                    logSets.append(" or ");
                } else if (i > 0) {
                    logSets.append(", ");
                }
                logSets.append("\"" + (String)setNames.get(i) + "\"");
            }
            NoSuchMethodException setMethodEx = null;
            for (String setName : setNames) {
                try {
                    spec.setSetMethod(PropertyScanner.findMethod(clazz, setName, field.getType()));
                    break;
                }
                catch (NoSuchMethodException ex) {
                    if (setMethodEx != null) continue;
                    setMethodEx = ex;
                }
            }
            if (spec.getSetMethod() == null) {
                throw new RuntimeException(String.format("Can't write property \"%s\" in class %s: Field is not public and method %s not found", spec.getName(), clazz.getName(), logSets.toString()) + ": " + setMethodEx.getMessage(), setMethodEx);
            }
        }
        return spec;
    }

    private static Field findDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException {
        NoSuchFieldException exception = null;
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            exception = ex;
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw exception;
            }
            try {
                return PropertyScanner.findDeclaredField(superClass, name);
            }
            catch (NoSuchFieldException ex2) {
                throw exception;
            }
        }
    }

    private static Method findMethod(Class<?> clazz, String name, Class<?> ... args) throws NoSuchMethodException {
        NoSuchMethodException exception = null;
        try {
            return clazz.getMethod(name, args);
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw exception;
            }
            try {
                return PropertyScanner.findMethod(superClass, name, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                throw exception;
            }
        }
    }
}

