/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.csv;

import eu.woolplatform.utils.exception.ParseException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class CsvParser {
    private LineNumberReader reader;

    public CsvParser(LineNumberReader reader) {
        this.reader = reader;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int getLineNumber() {
        return this.reader.getLineNumber() + 1;
    }

    public List<String> readLineColumns() throws ParseException, IOException {
        int lineNum = this.getLineNumber();
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean atColStart = true;
        StringBuilder stringBuilder = null;
        boolean prevQuote = false;
        int start = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                if (stringBuilder == null && !atColStart) {
                    throw new ParseException(String.format("Found \" after column start (line %s, column %s)", lineNum, i + 1));
                }
                atColStart = false;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    start = i + 1;
                    continue;
                }
                if (prevQuote) {
                    stringBuilder.append('\"');
                    prevQuote = false;
                    start = i + 1;
                    continue;
                }
                prevQuote = true;
                stringBuilder.append(line.substring(start, i));
                start = i;
                continue;
            }
            if (prevQuote) {
                if (c != ',') {
                    throw new ParseException(String.format("Found character %s after \" (line %s, column %s)", Character.valueOf(c), lineNum, i + 1));
                }
                this.addColumn(stringBuilder.toString(), result);
                atColStart = true;
                stringBuilder = null;
                prevQuote = false;
                start = i + 1;
                continue;
            }
            if (stringBuilder == null && c == ',') {
                this.addColumn(line.substring(start, i), result);
                atColStart = true;
                start = i + 1;
                continue;
            }
            atColStart = false;
        }
        if (prevQuote) {
            this.addColumn(stringBuilder.toString(), result);
        } else if (atColStart || start < line.length()) {
            this.addColumn(line.substring(start), result);
        }
        return result;
    }

    private void addColumn(String column, List<String> list) {
        if ((column = column.trim()).equals("NULL")) {
            list.add(null);
        } else {
            list.add(column);
        }
    }
}

