/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.datetime;

import eu.woolplatform.utils.exception.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeUtils {
    public static <T> T parseDateTime(String dateTimeString, Class<T> clazz) throws ParseException {
        try {
            long timestamp = Long.parseLong(dateTimeString);
            return DateTimeUtils.dateTimeToType(new DateTime(timestamp), clazz);
        }
        catch (NumberFormatException timestamp) {
            DateTime time;
            DateTimeFormatter parser = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
            LocalDate localDate = null;
            try {
                localDate = parser.parseLocalDate(dateTimeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                if (localDate != null) {
                    return clazz.cast(localDate);
                }
            }
            catch (ClassCastException ex) {
                throw new ParseException("Pattern yyyy-MM-dd expects result class LocalDate, found: " + clazz.getName());
            }
            parser = DateTimeFormat.forPattern((String)"HH:mm:ss");
            LocalTime localTime = null;
            try {
                localTime = parser.parseLocalTime(dateTimeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                if (localTime != null) {
                    return clazz.cast(localTime);
                }
            }
            catch (ClassCastException ex) {
                throw new ParseException("Pattern HH:mm:ss expects result class LocalTime, found: " + clazz.getName());
            }
            parser = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            LocalDateTime localDateTime = null;
            try {
                localDateTime = parser.parseLocalDateTime(dateTimeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                if (localDateTime != null) {
                    return clazz.cast(localDateTime);
                }
            }
            catch (ClassCastException ex) {
                throw new ParseException("Pattern yyyy-MM-dd HH:mm:ss expects result class LocalDateTime, found: " + clazz.getName());
            }
            try {
                parser = ISODateTimeFormat.dateTimeParser().withOffsetParsed();
                time = parser.parseDateTime(dateTimeString);
            }
            catch (IllegalArgumentException ex) {
                throw new ParseException("Invalid date/time string: " + dateTimeString + ": " + ex.getMessage(), ex);
            }
            try {
                return DateTimeUtils.dateTimeToType(time, clazz);
            }
            catch (IllegalArgumentException ex) {
                throw new ParseException("Invalid date/time target class: " + clazz.getName() + ": " + ex.getMessage(), ex);
            }
        }
    }

    public static <T> T dateTimeToType(DateTime dateTime, Class<T> clazz) throws IllegalArgumentException {
        if (clazz == Long.TYPE || clazz == Long.class) {
            Object result = Long.class.cast(dateTime.getMillis());
            return result;
        }
        if (clazz == Date.class) {
            return clazz.cast(dateTime.toDate());
        }
        if (clazz == Instant.class) {
            return clazz.cast(dateTime.toInstant());
        }
        if (clazz == Calendar.class) {
            return clazz.cast(dateTime.toCalendar(null));
        }
        if (clazz == DateTime.class) {
            return clazz.cast(dateTime);
        }
        if (clazz == LocalDate.class) {
            return clazz.cast(dateTime.toLocalDate());
        }
        if (clazz == LocalTime.class) {
            return clazz.cast(dateTime.toLocalTime());
        }
        if (clazz == LocalDateTime.class) {
            return clazz.cast(dateTime.toLocalDateTime());
        }
        throw new IllegalArgumentException("Unsupported date/time class: " + clazz.getName());
    }

    public static DateTime localToUtcWithGapCorrection(LocalDateTime localDateTime, DateTimeZone tz) {
        if (!tz.isLocalDateTimeGap(localDateTime)) {
            return localDateTime.toDateTime(tz);
        }
        return localDateTime.plusHours(1).toDateTime(tz);
    }
}

