/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.datetime;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class VirtualClock {
    private final Object lock = new Object();
    private boolean systemMode = true;
    private long systemAnchorTime;
    private long virtualAnchorTime = this.systemAnchorTime = System.currentTimeMillis();
    private float speed = 1.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVirtualMode() {
        Object object = this.lock;
        synchronized (object) {
            return !this.systemMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVirtualAnchorTime(Date time) {
        Object object = this.lock;
        synchronized (object) {
            this.systemAnchorTime = System.currentTimeMillis();
            this.virtualAnchorTime = time != null ? time.getTime() : this.systemAnchorTime;
            this.systemMode = this.virtualAnchorTime == this.systemAnchorTime && this.speed == 1.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeed(float speed) {
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            long systemElapsed = now - this.systemAnchorTime;
            long virtualElapsed = this.speed == 1.0f ? systemElapsed : Math.round((double)systemElapsed * (double)this.speed);
            this.systemAnchorTime = now;
            this.virtualAnchorTime += virtualElapsed;
            this.speed = speed;
            this.systemMode = this.virtualAnchorTime == this.systemAnchorTime && speed == 1.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long currentTimeMillis() {
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (this.systemMode) {
                return now;
            }
            long systemElapsed = now - this.systemAnchorTime;
            long virtualElapsed = this.speed == 1.0f ? systemElapsed : Math.round((double)systemElapsed * (double)this.speed);
            return this.virtualAnchorTime + virtualElapsed;
        }
    }

    public LocalDate getDate() {
        return this.getTime().toLocalDate();
    }

    public DateTime getTime() {
        return new DateTime(this.currentTimeMillis());
    }
}

