/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.exception;

import eu.woolplatform.utils.exception.ParseException;

public class LineNumberParseException
extends ParseException {
    private static final long serialVersionUID = 1L;
    private int lineNum;
    private int colNum;

    public LineNumberParseException(String message, int lineNum, int colNum) {
        this(message, lineNum, colNum, null);
    }

    public LineNumberParseException(String message, int lineNum, int colNum, Exception cause) {
        super(message + String.format(" (line %d, column %d)", lineNum, colNum), cause);
        this.lineNum = lineNum;
        this.colNum = colNum;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getColNum() {
        return this.colNum;
    }
}

