/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.expressions;

import eu.woolplatform.utils.exception.LineNumberParseException;
import eu.woolplatform.utils.expressions.Token;
import eu.woolplatform.utils.expressions.Value;
import eu.woolplatform.utils.io.LineColumnNumberReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer {
    private LineColumnNumberReader reader;
    private int currTokenLineNum;
    private int currTokenColNum;
    private long currTokenPos;
    private List<NameOrFixedToken> fixedTokens = new ArrayList<NameOrFixedToken>();
    private StringBuilder buffer = new StringBuilder();
    private List<NameOrFixedToken> candidateNameOrFixedTokens;
    private StringBuilder stringValue;
    private StringBuilder stringEscape = null;
    private NumberPos numberPos = null;
    private Object lookAheadState = null;

    public Tokenizer(String input) {
        this(new StringReader(input));
    }

    public Tokenizer(Reader reader) {
        this(new LineColumnNumberReader(reader));
    }

    public Tokenizer(LineColumnNumberReader reader) {
        this.reader = reader;
        this.fixedTokens.add(new NameOrFixedToken("=", Token.Type.ASSIGN));
        this.fixedTokens.add(new NameOrFixedToken("||", Token.Type.OR));
        this.fixedTokens.add(new NameOrFixedToken("&&", Token.Type.AND));
        this.fixedTokens.add(new NameOrFixedToken("!", Token.Type.NOT));
        this.fixedTokens.add(new NameOrFixedToken("in", Token.Type.IN));
        this.fixedTokens.add(new NameOrFixedToken("<", Token.Type.LESS_THAN));
        this.fixedTokens.add(new NameOrFixedToken("<=", Token.Type.LESS_EQUAL));
        this.fixedTokens.add(new NameOrFixedToken("==", Token.Type.EQUAL));
        this.fixedTokens.add(new NameOrFixedToken("!=", Token.Type.NOT_EQUAL));
        this.fixedTokens.add(new NameOrFixedToken("===", Token.Type.STRICT_EQUAL));
        this.fixedTokens.add(new NameOrFixedToken("!==", Token.Type.NOT_STRICT_EQUAL));
        this.fixedTokens.add(new NameOrFixedToken(">=", Token.Type.GREATER_EQUAL));
        this.fixedTokens.add(new NameOrFixedToken(">", Token.Type.GREATER_THAN));
        this.fixedTokens.add(new NameOrFixedToken("+", Token.Type.ADD));
        this.fixedTokens.add(new NameOrFixedToken("-", Token.Type.SUBTRACT));
        this.fixedTokens.add(new NameOrFixedToken("/", Token.Type.DIVIDE));
        this.fixedTokens.add(new NameOrFixedToken(".", Token.Type.DOT));
        this.fixedTokens.add(new NameOrFixedToken("*", Token.Type.MULTIPLY));
        this.fixedTokens.add(new NameOrFixedToken("[", Token.Type.BRACKET_OPEN));
        this.fixedTokens.add(new NameOrFixedToken("]", Token.Type.BRACKET_CLOSE));
        this.fixedTokens.add(new NameOrFixedToken("(", Token.Type.PARENTHESIS_OPEN));
        this.fixedTokens.add(new NameOrFixedToken(")", Token.Type.PARENTHESIS_CLOSE));
        this.fixedTokens.add(new NameOrFixedToken("{", Token.Type.BRACE_OPEN));
        this.fixedTokens.add(new NameOrFixedToken("}", Token.Type.BRACE_CLOSE));
        this.fixedTokens.add(new NameOrFixedToken(",", Token.Type.COMMA));
        this.fixedTokens.add(new NameOrFixedToken(":", Token.Type.COLON));
        this.fixedTokens.add(new NameOrFixedToken("true", Token.Type.BOOLEAN));
        this.fixedTokens.add(new NameOrFixedToken("false", Token.Type.BOOLEAN));
        this.fixedTokens.add(new NameOrFixedToken("null", Token.Type.NULL));
    }

    public LineColumnNumberReader getReader() {
        return this.reader;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Token readToken() throws LineNumberParseException, IOException {
        if (this.lookAheadState != null) {
            this.reader.clearRestoreState(this.lookAheadState);
        }
        this.lookAheadState = this.reader.getRestoreState();
        this.skipWhitespace();
        this.currTokenLineNum = this.reader.getLineNum();
        this.currTokenColNum = this.reader.getColNum();
        this.currTokenPos = this.reader.getPosition();
        Object restoreState = this.reader.getRestoreState(1);
        try {
            int next = this.reader.read();
            if (next == -1) {
                Token token = null;
                return token;
            }
            char c = (char)next;
            this.candidateNameOrFixedTokens = this.getCandidateNameOrFixedTokens(c);
            if (!this.candidateNameOrFixedTokens.isEmpty()) {
                this.buffer.append(c);
                Token token = this.readNameOrFixedToken();
                return token;
            }
            if (c == '\"') {
                this.buffer.append(c);
                Token token = this.readStringToken();
                return token;
            }
            if (c == '-' || c >= '0' && c <= '9') {
                this.reader.restoreState(restoreState);
                Token token = this.readNumberToken();
                return token;
            }
            if (c == '$') {
                this.buffer.append(c);
                Token token = this.readDollarVariableToken();
                return token;
            }
            this.buffer.append(c);
            throw this.createParseException("Invalid character: " + c, this.currTokenLineNum, this.currTokenColNum);
        }
        finally {
            this.reader.clearRestoreState(restoreState);
        }
    }

    public int getLineNum() {
        return this.reader.getLineNum();
    }

    public int getColNum() {
        return this.reader.getColNum();
    }

    public void rewind() throws IOException {
        if (this.lookAheadState == null) {
            throw new IOException("Rewind can only be executed once after readToken()");
        }
        this.reader.restoreState(this.lookAheadState);
        this.lookAheadState = null;
    }

    private List<NameOrFixedToken> getCandidateNameOrFixedTokens(char c) {
        ArrayList<NameOrFixedToken> result = new ArrayList<NameOrFixedToken>();
        String s = this.buffer.toString() + c;
        for (NameOrFixedToken fixedToken : this.fixedTokens) {
            if (!fixedToken.text.startsWith(s)) continue;
            result.add(fixedToken);
        }
        if (s.matches("[_a-zA-Z][_a-zA-Z0-9]*")) {
            result.add(new NameOrFixedToken(null, Token.Type.NAME));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token readNameOrFixedToken() throws LineNumberParseException, IOException {
        NameOrFixedToken completeFixedToken = this.findCompleteFixedToken();
        if (this.candidateNameOrFixedTokens.size() == 1 && completeFixedToken != null) {
            return this.completeNameOrFixedToken(completeFixedToken);
        }
        while (true) {
            Object restoreState = this.reader.getRestoreState(1);
            try {
                int next = this.reader.read();
                if (next == -1) {
                    Token token = this.tryCompleteNameOrFixedToken();
                    return token;
                }
                NameOrFixedToken completeToken = this.findCompleteNameOrFixedToken();
                char c = (char)next;
                List<NameOrFixedToken> remainTokens = this.getCandidateNameOrFixedTokens(c);
                if (remainTokens.isEmpty()) {
                    if (completeToken != null) {
                        this.reader.restoreState(restoreState);
                        Token token = this.completeNameOrFixedToken(completeToken);
                        return token;
                    }
                    this.buffer.append(c);
                    throw this.createParseException("Invalid token: " + this.buffer, this.currTokenLineNum, this.currTokenColNum);
                }
                this.candidateNameOrFixedTokens = remainTokens;
                this.buffer.append(c);
                completeFixedToken = this.findCompleteFixedToken();
                if (this.candidateNameOrFixedTokens.size() != 1 || completeFixedToken == null) continue;
                Token token = this.completeNameOrFixedToken(completeFixedToken);
                return token;
            }
            finally {
                this.reader.clearRestoreState(restoreState);
                continue;
            }
            break;
        }
    }

    private NameOrFixedToken findCompleteFixedToken() {
        for (NameOrFixedToken token : this.candidateNameOrFixedTokens) {
            if (token.token == Token.Type.NAME || this.buffer.length() != token.text.length()) continue;
            return token;
        }
        return null;
    }

    private NameOrFixedToken findCompleteNameOrFixedToken() {
        NameOrFixedToken fixedToken = this.findCompleteFixedToken();
        if (fixedToken != null) {
            return fixedToken;
        }
        for (NameOrFixedToken token : this.candidateNameOrFixedTokens) {
            if (token.token != Token.Type.NAME) continue;
            return token;
        }
        return null;
    }

    private Token tryCompleteNameOrFixedToken() throws LineNumberParseException {
        String text = this.buffer.toString();
        NameOrFixedToken completeToken = this.findCompleteNameOrFixedToken();
        if (completeToken == null) {
            throw this.createParseException("Invalid token: " + text, this.currTokenLineNum, this.currTokenColNum);
        }
        return this.completeNameOrFixedToken(completeToken);
    }

    private Token completeNameOrFixedToken(NameOrFixedToken completeToken) {
        Token result;
        Token.Type type = completeToken.token;
        String text = this.buffer.toString();
        if (type == Token.Type.NAME) {
            result = new Token(type, text, this.currTokenLineNum, this.currTokenColNum, this.currTokenPos, new Value(text));
        } else {
            Value value = null;
            if (type == Token.Type.BOOLEAN) {
                value = new Value(text.equals("true"));
            } else if (type == Token.Type.NULL) {
                value = new Value(null);
            }
            result = new Token(type, text, this.currTokenLineNum, this.currTokenColNum, this.currTokenPos, value);
        }
        this.buffer = new StringBuilder();
        this.candidateNameOrFixedTokens = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token readDollarVariableToken() throws LineNumberParseException, IOException {
        Pattern regex = Pattern.compile("\\$[_a-zA-Z][_a-zA-Z0-9]*");
        while (true) {
            Object restoreState = this.reader.getRestoreState(1);
            try {
                Matcher m = regex.matcher(this.buffer);
                boolean currentOk = m.matches();
                int next = this.reader.read();
                if (next == -1) {
                    if (!currentOk) {
                        throw this.createParseException("Invalid token: " + this.buffer, this.currTokenLineNum, this.currTokenColNum);
                    }
                    Token token = this.completeDollarVariableToken();
                    return token;
                }
                char c = (char)next;
                m = regex.matcher(this.buffer.toString() + c);
                boolean newOk = m.matches();
                if (newOk) {
                    this.buffer.append(c);
                    continue;
                }
                if (currentOk) {
                    this.reader.restoreState(restoreState);
                    Token token = this.completeDollarVariableToken();
                    return token;
                }
                throw this.createParseException("Invalid token: " + this.buffer, this.currTokenLineNum, this.currTokenColNum);
            }
            finally {
                this.reader.clearRestoreState(restoreState);
                continue;
            }
            break;
        }
    }

    private Token completeDollarVariableToken() {
        Token result = new Token(Token.Type.DOLLAR_VARIABLE, this.buffer.toString(), this.currTokenLineNum, this.currTokenColNum, this.currTokenPos, new Value(this.buffer.substring(1)));
        this.buffer = new StringBuilder();
        return result;
    }

    private Token readStringToken() throws LineNumberParseException, IOException {
        if (this.stringValue == null) {
            this.stringValue = new StringBuilder();
        }
        while (true) {
            if (this.stringEscape != null) {
                this.readStringEscape();
            }
            int charLineNum = this.reader.getLineNum();
            int charColNum = this.reader.getColNum();
            int special = 0;
            while (special == 0) {
                int next = this.reader.read();
                if (next == -1) {
                    throw this.createParseException("Incomplete string", this.currTokenLineNum, this.currTokenColNum);
                }
                char c = (char)next;
                this.buffer.append(c);
                if (Character.isISOControl(c)) {
                    throw this.createParseException("Found control character in string", charLineNum, charColNum);
                }
                if (c == '\"' || c == '\\') {
                    special = c;
                    break;
                }
                ++charColNum;
                this.stringValue.append(c);
            }
            if (special == 34) {
                Token result = new Token(Token.Type.STRING, this.buffer.toString(), this.currTokenLineNum, this.currTokenColNum, this.currTokenPos, new Value(this.stringValue.toString()));
                this.buffer = new StringBuilder();
                this.stringValue = null;
                return result;
            }
            this.stringEscape = new StringBuilder();
        }
    }

    private void readStringEscape() throws LineNumberParseException, IOException {
        block9: while (true) {
            int charLineNum = this.reader.getLineNum();
            int charColNum = this.reader.getColNum();
            int next = this.reader.read();
            if (next == -1) {
                return;
            }
            char c = (char)next;
            this.buffer.append(c);
            if (this.stringEscape.length() == 0) {
                switch (c) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        this.stringValue.append(c);
                        this.stringEscape = null;
                        return;
                    }
                    case 'b': {
                        this.stringValue.append('\b');
                        this.stringEscape = null;
                        return;
                    }
                    case 'f': {
                        this.stringValue.append('\f');
                        this.stringEscape = null;
                        return;
                    }
                    case 'n': {
                        this.stringValue.append('\n');
                        this.stringEscape = null;
                        return;
                    }
                    case 'r': {
                        this.stringValue.append('\r');
                        this.stringEscape = null;
                        return;
                    }
                    case 't': {
                        this.stringValue.append('\t');
                        this.stringEscape = null;
                        return;
                    }
                    case 'u': {
                        this.stringEscape.append(c);
                        continue block9;
                    }
                }
                throw this.createParseException("Invalid string escape character: " + c, charLineNum, charColNum);
            }
            if (this.stringEscape.length() >= 5) continue;
            if (!Character.toString(c).matches("[A-Fa-f0-9]")) {
                throw this.createParseException("Invalid hexadecimal character in unicode escape: " + c, charLineNum, charColNum);
            }
            this.stringEscape.append(c);
            if (this.stringEscape.length() == 5) break;
        }
        int codePoint = Integer.parseInt(this.stringEscape.substring(1), 16);
        char[] unicode = Character.toChars(codePoint);
        this.stringValue.append(unicode);
        this.stringEscape = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token readNumberToken() throws LineNumberParseException, IOException {
        while (true) {
            Object restoreState = this.reader.getRestoreState(1);
            try {
                int next = this.reader.read();
                if (next == -1) {
                    Token token = this.tryCompleteNumber();
                    return token;
                }
                char c = (char)next;
                Token token = this.parseNumberChar(c);
                if (token != null) {
                    this.reader.restoreState(restoreState);
                    Token token2 = token;
                    return token2;
                }
                this.buffer.append(c);
                continue;
            }
            finally {
                this.reader.clearRestoreState(restoreState);
                continue;
            }
            break;
        }
    }

    private Token parseNumberChar(char c) throws LineNumberParseException {
        if (this.numberPos == null) {
            if (c == '-') {
                this.numberPos = NumberPos.AFTER_MAIN_SIGN;
                return null;
            }
            if (c == '0') {
                this.numberPos = NumberPos.AFTER_MAIN;
                return null;
            }
            this.numberPos = NumberPos.IN_MAIN;
            return null;
        }
        switch (this.numberPos) {
            case AFTER_MAIN_SIGN: {
                if (c == '0') {
                    this.numberPos = NumberPos.AFTER_MAIN;
                    return null;
                }
                if (c >= '1' && c <= '9') {
                    this.numberPos = NumberPos.IN_MAIN;
                    return null;
                }
                throw this.createParseException("Invalid number: " + this.buffer + c, this.currTokenLineNum, this.currTokenColNum);
            }
            case AFTER_MAIN: {
                if (c == '.') {
                    this.numberPos = NumberPos.AFTER_POINT;
                    return null;
                }
                if (c == 'e' || c == 'E') {
                    this.numberPos = NumberPos.AFTER_EXP;
                    return null;
                }
                return this.tryCompleteNumber();
            }
            case IN_MAIN: {
                if (c >= '0' && c <= '9') {
                    return null;
                }
                if (c == '.') {
                    this.numberPos = NumberPos.AFTER_POINT;
                    return null;
                }
                if (c == 'e' || c == 'E') {
                    this.numberPos = NumberPos.AFTER_EXP;
                    return null;
                }
                return this.tryCompleteNumber();
            }
            case AFTER_POINT: {
                if (c >= '0' && c <= '9') {
                    this.numberPos = NumberPos.IN_FRACTION;
                    return null;
                }
                throw this.createParseException("Invalid number: " + this.buffer + c, this.currTokenLineNum, this.currTokenColNum);
            }
            case IN_FRACTION: {
                if (c >= '0' && c <= '9') {
                    return null;
                }
                if (c == 'e' || c == 'E') {
                    this.numberPos = NumberPos.AFTER_EXP;
                    return null;
                }
                return this.tryCompleteNumber();
            }
            case AFTER_EXP: {
                if (c == '+' || c == '-') {
                    this.numberPos = NumberPos.AFTER_EXP_SIGN;
                    return null;
                }
                if (c >= '0' && c <= '9') {
                    this.numberPos = NumberPos.IN_EXP_NUMBER;
                    return null;
                }
                throw this.createParseException("Invalid number: " + this.buffer + c, this.currTokenLineNum, this.currTokenColNum);
            }
            case AFTER_EXP_SIGN: {
                if (c >= '0' && c <= '9') {
                    this.numberPos = NumberPos.IN_EXP_NUMBER;
                    return null;
                }
                throw this.createParseException("Invalid number: " + this.buffer + c, this.currTokenLineNum, this.currTokenColNum);
            }
            case IN_EXP_NUMBER: {
                if (c >= '0' && c <= '9') {
                    this.numberPos = NumberPos.IN_EXP_NUMBER;
                    return null;
                }
                return this.tryCompleteNumber();
            }
        }
        throw new RuntimeException("Unknown number position: " + (Object)((Object)this.numberPos));
    }

    private Token tryCompleteNumber() throws LineNumberParseException {
        long longVal;
        List<NumberPos> endStates = Arrays.asList(NumberPos.AFTER_MAIN, NumberPos.IN_MAIN, NumberPos.IN_FRACTION, NumberPos.IN_EXP_NUMBER);
        if (!endStates.contains((Object)this.numberPos)) {
            throw this.createParseException("Invalid number: " + this.buffer, this.currTokenLineNum, this.currTokenColNum);
        }
        Number value = this.numberPos == NumberPos.AFTER_MAIN || this.numberPos == NumberPos.IN_MAIN ? (Number)((longVal = Long.parseLong(this.buffer.toString())) >= Integer.MIN_VALUE && longVal <= Integer.MAX_VALUE ? (Number)((int)longVal) : (Number)longVal) : (Number)Double.parseDouble(this.buffer.toString());
        Token result = new Token(Token.Type.NUMBER, this.buffer.toString(), this.currTokenLineNum, this.currTokenColNum, this.currTokenPos, new Value(value));
        this.buffer = new StringBuilder();
        this.numberPos = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipWhitespace() throws IOException {
        while (true) {
            Object restoreState = this.reader.getRestoreState(1);
            try {
                int next = this.reader.read();
                if (next == -1) {
                    return;
                }
                char c = (char)next;
                if (Character.isWhitespace(c)) continue;
                this.reader.restoreState(restoreState);
                return;
            }
            finally {
                this.reader.clearRestoreState(restoreState);
                continue;
            }
            break;
        }
    }

    private LineNumberParseException createParseException(String message, int lineNum, int colNum) {
        return new LineNumberParseException(message, lineNum, colNum);
    }

    private class NameOrFixedToken {
        public String text;
        public Token.Type token;

        public NameOrFixedToken(String text, Token.Type token) {
            this.text = text;
            this.token = token;
        }
    }

    private static enum NumberPos {
        AFTER_MAIN_SIGN,
        AFTER_MAIN,
        IN_MAIN,
        AFTER_POINT,
        IN_FRACTION,
        AFTER_EXP,
        AFTER_EXP_SIGN,
        IN_EXP_NUMBER;

    }
}

