/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.expressions.types;

import eu.woolplatform.utils.exception.LineNumberParseException;
import eu.woolplatform.utils.expressions.EvaluationException;
import eu.woolplatform.utils.expressions.Expression;
import eu.woolplatform.utils.expressions.Token;
import eu.woolplatform.utils.expressions.Value;
import eu.woolplatform.utils.expressions.types.ValueExpression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AssignExpression
implements Expression {
    private Expression variableOperand;
    private String variableName;
    private Expression valueOperand;

    public AssignExpression(Expression variableOperand, Token operator, Expression valueOperand) throws LineNumberParseException {
        if (!(variableOperand instanceof ValueExpression)) {
            throw new LineNumberParseException("First operand of assign expression must be a variable", operator.getLineNum(), operator.getColNum());
        }
        ValueExpression variableExpr = (ValueExpression)variableOperand;
        Token variableToken = variableExpr.getToken();
        if (variableToken.getType() != Token.Type.NAME && variableToken.getType() != Token.Type.DOLLAR_VARIABLE) {
            throw new LineNumberParseException("First operand of assign expression must be a variable", operator.getLineNum(), operator.getColNum());
        }
        this.variableOperand = variableOperand;
        this.variableName = variableToken.getValue().toString();
        this.valueOperand = valueOperand;
    }

    public Expression getVariableOperand() {
        return this.variableOperand;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Expression getValueOperand() {
        return this.valueOperand;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        Value result = this.valueOperand.evaluate(variables);
        if (variables != null) {
            variables.put(this.variableName, result.getValue());
        }
        return result;
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(this.variableOperand);
        result.add(this.valueOperand);
        return result;
    }

    @Override
    public List<Expression> getDescendants() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression child : this.getChildren()) {
            result.add(child);
            result.addAll(child.getDescendants());
        }
        return result;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.variableName);
        result.addAll(this.valueOperand.getVariableNames());
        return result;
    }

    public String toString() {
        return this.variableOperand + " = " + this.valueOperand;
    }
}

