/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.expressions.types;

import eu.woolplatform.utils.expressions.EvaluationException;
import eu.woolplatform.utils.expressions.Expression;
import eu.woolplatform.utils.expressions.Token;
import eu.woolplatform.utils.expressions.Value;
import eu.woolplatform.utils.expressions.types.ValueExpression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DotExpression
implements Expression {
    private Expression parentOperand;
    private Expression dotOperand;

    public DotExpression(Expression parentOperand, Expression dotOperand) {
        this.parentOperand = parentOperand;
        this.dotOperand = dotOperand;
    }

    public Expression getParentOperand() {
        return this.parentOperand;
    }

    public Expression getDotOperand() {
        return this.dotOperand;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        ValueExpression valueExpr;
        Value parent = this.parentOperand.evaluate(variables);
        if (!parent.isMap()) {
            throw new EvaluationException("Dot parent must be a map, found: " + parent.getTypeString());
        }
        Map map = (Map)parent.getValue();
        String name = null;
        if (this.dotOperand instanceof ValueExpression && (valueExpr = (ValueExpression)this.dotOperand).getToken().getType() == Token.Type.NAME) {
            name = valueExpr.getToken().getValue().toString();
        }
        if (name == null) {
            Value nameVal = this.dotOperand.evaluate(variables);
            if (!nameVal.isString() && !nameVal.isNumber()) {
                throw new EvaluationException("Dot name must be a string or number, found: " + nameVal.getTypeString());
            }
            name = nameVal.toString();
        }
        return new Value(map.get(name));
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(this.parentOperand);
        result.add(this.dotOperand);
        return result;
    }

    @Override
    public List<Expression> getDescendants() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression child : this.getChildren()) {
            result.add(child);
            result.addAll(child.getDescendants());
        }
        return result;
    }

    @Override
    public Set<String> getVariableNames() {
        ValueExpression valueExpr;
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.parentOperand.getVariableNames());
        boolean dotOperandIsName = false;
        if (this.dotOperand instanceof ValueExpression && (valueExpr = (ValueExpression)this.dotOperand).getToken().getType() == Token.Type.NAME) {
            dotOperandIsName = true;
        }
        if (!dotOperandIsName) {
            result.addAll(this.dotOperand.getVariableNames());
        }
        return result;
    }

    public String toString() {
        return this.parentOperand + "." + this.dotOperand;
    }
}

