/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.expressions.types;

import eu.woolplatform.utils.expressions.EvaluationException;
import eu.woolplatform.utils.expressions.Expression;
import eu.woolplatform.utils.expressions.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NotExpression
implements Expression {
    private Expression operand;

    public NotExpression(Expression operand) {
        this.operand = operand;
    }

    public Expression getOperand() {
        return this.operand;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        return new Value(!this.operand.evaluate(variables).asBoolean());
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(this.operand);
        return result;
    }

    @Override
    public List<Expression> getDescendants() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression child : this.getChildren()) {
            result.add(child);
            result.addAll(child.getDescendants());
        }
        return result;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        for (Expression child : this.getChildren()) {
            result.addAll(child.getVariableNames());
        }
        return result;
    }

    public String toString() {
        return "!" + this.operand;
    }
}

