/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.expressions.types;

import eu.woolplatform.utils.expressions.EvaluationException;
import eu.woolplatform.utils.expressions.Expression;
import eu.woolplatform.utils.expressions.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NotStrictEqualExpression
implements Expression {
    private Expression operand1;
    private Expression operand2;

    public NotStrictEqualExpression(Expression operand1, Expression operand2) {
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        Value val2;
        Value val1 = this.operand1.evaluate(variables);
        return new Value(!val1.isStrictEqual(val2 = this.operand2.evaluate(variables)));
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(this.operand1);
        result.add(this.operand2);
        return result;
    }

    @Override
    public List<Expression> getDescendants() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression child : this.getChildren()) {
            result.add(child);
            result.addAll(child.getDescendants());
        }
        return result;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        for (Expression child : this.getChildren()) {
            result.addAll(child.getVariableNames());
        }
        return result;
    }

    public String toString() {
        return this.operand1 + " !== " + this.operand2;
    }
}

