/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.geom;

import eu.woolplatform.utils.geom.Point;
import eu.woolplatform.utils.geom.Vector;

public class Line {
    private Point origin;
    private Vector vector;

    public Line(Point origin, Vector vector) {
        this.origin = origin;
        this.vector = vector;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point origin) {
        this.origin = origin;
    }

    public Vector getVector() {
        return this.vector;
    }

    public void setVector(Vector vector) {
        this.vector = vector;
    }

    public boolean isParallel(Line other) {
        return this.vector.isParallel(other.vector);
    }

    public boolean containsPoint(Point point) {
        double vectorDir;
        double dy;
        if (point.equals(this.origin)) {
            return true;
        }
        if (this.vector.getDx() == 0.0) {
            return point.getX() == this.origin.getX();
        }
        if (this.vector.getDy() == 0.0) {
            return point.getY() == this.origin.getY();
        }
        double dx = point.getX() - this.origin.getX();
        double originToPoint = dx / (dy = point.getY() - this.origin.getY());
        return originToPoint == (vectorDir = this.vector.getDx() / this.vector.getDy());
    }

    public Point findIntersection(Line other) {
        if (other.equals(this)) {
            return this.origin;
        }
        if (other.isParallel(this)) {
            if (other.containsPoint(this.origin)) {
                return this.origin;
            }
            return null;
        }
        Point o1 = this.origin;
        Point o2 = other.origin;
        Vector v1 = this.vector;
        Vector v2 = other.vector;
        if (v1.getDx() == 0.0) {
            double b = (o1.getX() - o2.getX()) / v2.getDx();
            return new Point(o1.getX(), o2.getY() + b * v2.getDy());
        }
        if (v2.getDx() == 0.0) {
            double b = (o2.getX() - o1.getX()) / v1.getDx();
            return new Point(o2.getX(), o1.getY() + b * v1.getDy());
        }
        if (v1.getDy() == 0.0) {
            double b = (o1.getY() - o2.getY()) / v2.getDy();
            return new Point(o2.getX() + b * v2.getDx(), o1.getY());
        }
        if (v2.getDy() == 0.0) {
            double b = (o2.getY() - o1.getY()) / v1.getDy();
            return new Point(o1.getX() + b * v1.getDx(), o2.getY());
        }
        double c1 = o1.getY() - o2.getY() + (o2.getX() - o1.getX()) * v1.getDy() / v1.getDx();
        double c2 = v2.getDy() - v2.getDx() * v1.getDy() / v1.getDx();
        double b = c1 / c2;
        return new Point(o2.getX() + b * v2.getDx(), o2.getY() + b * v2.getDy());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Line other = (Line)obj;
        if (!this.origin.equals(other.origin)) {
            return false;
        }
        return this.vector.equals(other.vector);
    }

    public int hashCode() {
        int result = this.origin.hashCode();
        result = 31 * result + this.vector.hashCode();
        return result;
    }
}

