/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.geom;

import eu.woolplatform.utils.geom.Point;
import eu.woolplatform.utils.geom.Vector;

public class LineSegment {
    private Point start;
    private Point end;

    public LineSegment(Point start, Point end) {
        this.start = start;
        this.end = end;
    }

    public LineSegment(double startX, double startY, double endX, double endY) {
        this.start = new Point(startX, startY);
        this.end = new Point(endX, endY);
    }

    public LineSegment(Point start, Vector vector) {
        this.start = start;
        this.end = new Point(start.getX() + vector.getDx(), start.getY() + vector.getDy());
    }

    public Point getStart() {
        return this.start;
    }

    public void setStart(Point start) {
        this.start = start;
    }

    public Point getEnd() {
        return this.end;
    }

    public void setEnd(Point end) {
        this.end = end;
    }

    public Vector toVector() {
        return new Vector(this.end.getX() - this.start.getX(), this.end.getY() - this.start.getY());
    }

    public double getLength() {
        return this.toVector().getLength();
    }

    public void rotate(double angle) {
        Vector vector = this.toVector();
        vector.rotate(angle);
        this.end.set(this.start.getX() + vector.getDx(), this.start.getY() + vector.getDy());
    }

    public void offset(double dx, double dy) {
        this.start.offset(dx, dy);
        this.end.offset(dx, dy);
    }

    public String toString() {
        return this.start + " - " + this.end;
    }
}

