/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.geom;

import eu.woolplatform.utils.geom.LineSegment;
import eu.woolplatform.utils.geom.Point;
import eu.woolplatform.utils.geom.Rect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Polygon {
    private List<Point> points = new ArrayList<Point>();

    public Polygon() {
    }

    public Polygon(List<Point> points) {
        this.points = points;
    }

    public Polygon(Point ... points) {
        this.points = Arrays.asList(points);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public void setPoints(Point ... points) {
        this.points = Arrays.asList(points);
    }

    public void addPoints(Point ... points) {
        for (Point point : points) {
            this.points.add(point);
        }
    }

    public Rect getBounds() {
        double minTop;
        double minLeft;
        if (this.points.isEmpty()) {
            return new Rect(0.0, 0.0, 0.0, 0.0);
        }
        Point first = this.points.get(0);
        double maxRight = minLeft = first.getX();
        double maxBottom = minTop = first.getY();
        for (int i = 1; i < this.points.size(); ++i) {
            Point p = this.points.get(i);
            if (p.getX() < minLeft) {
                minLeft = p.getX();
            }
            if (p.getX() > maxRight) {
                maxRight = p.getX();
            }
            if (p.getY() < minTop) {
                minTop = p.getY();
            }
            if (!(p.getY() > maxBottom)) continue;
            maxBottom = p.getY();
        }
        return new Rect(minLeft, minTop, maxRight, maxBottom);
    }

    public void offset(double dx, double dy) {
        for (Point point : this.points) {
            point.offset(dx, dy);
        }
    }

    public void rotate(float angle) {
        if (this.points.size() <= 1) {
            return;
        }
        ArrayList<LineSegment> lines = new ArrayList<LineSegment>();
        for (int i = 1; i < this.points.size(); ++i) {
            lines.add(new LineSegment(new Point(this.points.get(i - 1)), new Point(this.points.get(i))));
        }
        this.points = new ArrayList<Point>();
        Point lastPoint = null;
        for (LineSegment line : lines) {
            if (lastPoint == null) {
                this.points.add(line.getStart());
            } else {
                double dx = lastPoint.getX() - line.getStart().getX();
                double dy = lastPoint.getY() - line.getStart().getY();
                line.offset(dx, dy);
            }
            line.rotate(angle);
            lastPoint = line.getEnd();
            this.points.add(lastPoint);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Point point : this.points) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(point);
        }
        return builder.toString();
    }
}

