/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.geom;

public class Vector {
    private double dx;
    private double dy;

    public Vector(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public static Vector fromAngle(double angle, double length) {
        if ((angle %= 360.0) < 0.0) {
            angle += 360.0;
        }
        if (angle == 0.0) {
            return new Vector(length, 0.0);
        }
        if (angle == 90.0) {
            return new Vector(0.0, length);
        }
        if (angle == 180.0) {
            return new Vector(-length, 0.0);
        }
        if (angle == 270.0) {
            return new Vector(0.0, -length);
        }
        double rad = angle * Math.PI / 180.0;
        return new Vector(length * Math.cos(rad), length * Math.sin(rad));
    }

    public double getDx() {
        return this.dx;
    }

    public void setDx(double dx) {
        this.dx = dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setDy(double dy) {
        this.dy = dy;
    }

    public void rotate(double angle) {
        if ((angle %= 360.0) < 0.0) {
            angle += 360.0;
        }
        if (angle == 90.0) {
            double oldDx = this.dx;
            this.dx = -this.dy;
            this.dy = oldDx;
        } else if (angle == 180.0) {
            this.dx = -this.dx;
            this.dy = -this.dx;
        } else if (angle == 270.0) {
            double oldDx = this.dx;
            this.dx = this.dy;
            this.dy = -oldDx;
        } else if (angle > 0.0) {
            double newAngle = (this.getAngle() + angle) % 360.0;
            double length = this.getLength();
            double rad = newAngle * Math.PI / 180.0;
            this.dx = length * Math.cos(rad);
            this.dy = length * Math.sin(rad);
        }
    }

    public double getAngle() {
        if (this.dx == 0.0) {
            if (this.dy > 0.0) {
                return 90.0;
            }
            return 270.0;
        }
        if (this.dy == 0.0) {
            if (this.dx > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        double tan = Math.atan(this.dy / this.dx) * 180.0 / Math.PI;
        if (this.dx > 0.0 && this.dy > 0.0) {
            return tan;
        }
        if (this.dx > 0.0 && this.dy < 0.0) {
            return tan + 360.0;
        }
        return tan + 180.0;
    }

    public double getLength() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    public boolean isParallel(Vector other) {
        if (this.dx == 0.0) {
            return other.dx == 0.0;
        }
        if (this.dy == 0.0) {
            return other.dy == 0.0;
        }
        double dir1 = this.dx / this.dy;
        double dir2 = other.dx / other.dy;
        return dir1 == dir2;
    }

    public int hashCode() {
        int result = this.dx == 0.0 ? 0 : (int)Double.doubleToLongBits(this.dx);
        result = (double)(31 * result) + this.dy == 0.0 ? 0 : (int)Double.doubleToLongBits(this.dy);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector other = (Vector)obj;
        if (this.dx != other.dx) {
            return false;
        }
        return this.dy == other.dy;
    }

    public String toString() {
        return "(" + this.dx + ", " + this.dy + ")";
    }
}

