/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.http;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.i18n.I18nUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AcceptLanguageParser {
    public static List<Locale> parse(String acceptLanguage) {
        ArrayList<Locale> result = new ArrayList<Locale>();
        if ((acceptLanguage = acceptLanguage.trim()).length() == 0) {
            return result;
        }
        String[] languages = acceptLanguage.split(",");
        ArrayList<LanguageWeight> lws = new ArrayList<LanguageWeight>();
        for (String language : languages) {
            language = language.trim();
            lws.add(AcceptLanguageParser.parseLanguageWeight(language));
        }
        Collections.sort(lws, new WeightComparator());
        for (LanguageWeight lw : lws) {
            Locale locale;
            if (lw.language.equals("*")) {
                return result;
            }
            try {
                locale = I18nUtils.languageTagToLocale(lw.language);
            }
            catch (ParseException ex) {
                locale = null;
            }
            if (locale == null) continue;
            result.add(locale);
        }
        return result;
    }

    private static LanguageWeight parseLanguageWeight(String languageWeight) {
        LanguageWeight result = new LanguageWeight();
        result.weight = 1.0f;
        int sep = (languageWeight = languageWeight.trim()).indexOf(59);
        if (sep == -1) {
            result.language = languageWeight;
            return result;
        }
        result.language = languageWeight.substring(0, sep).trim();
        String weightSpec = languageWeight.substring(sep + 1).trim();
        Pattern regex = Pattern.compile("q\\s*=\\s*(\\S+)");
        Matcher m = regex.matcher(weightSpec);
        if (!m.matches()) {
            return result;
        }
        String weight = m.group(1);
        try {
            result.weight = Float.parseFloat(weight);
        }
        catch (NumberFormatException ex) {
            return result;
        }
        return result;
    }

    private static class WeightComparator
    implements Comparator<LanguageWeight> {
        private WeightComparator() {
        }

        @Override
        public int compare(LanguageWeight o1, LanguageWeight o2) {
            return -Float.compare(o1.weight, o2.weight);
        }
    }

    private static class LanguageWeight {
        public String language;
        public float weight;

        private LanguageWeight() {
        }
    }
}

