/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.http;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.http.HttpClientException;
import eu.woolplatform.utils.http.URLParameters;
import eu.woolplatform.utils.io.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpClient {
    private String method = "GET";
    private String url;
    private Map<String, String> queryParams = new LinkedHashMap<String, String>();
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private boolean wrotePostParam = false;
    private HttpURLConnection connection = null;
    private Map<String, String> responseHeaders = null;
    private InputStream input = null;
    private Reader reader = null;
    private OutputStream output = null;
    private Writer writer = null;
    private final Object lock = new Object();
    private boolean closed = false;

    public HttpClient(String url) {
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    public HttpClient setMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpClient addQueryParam(String name, String value) {
        this.queryParams.put(name, value);
        return this;
    }

    public HttpClient setQueryParams(Map<String, String> params) {
        this.queryParams = params;
        return this;
    }

    public HttpClient addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpClient setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String getUrl() {
        String url = this.url;
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            url = url + "?" + URLParameters.getParameterString(this.queryParams);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection getConnection() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("HttpClient closed");
            }
            if (this.connection != null) {
                return this.connection;
            }
        }
        URL url = new URL(this.getUrl());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(this.method);
        for (String header : this.headers.keySet()) {
            conn.setRequestProperty(header, this.headers.get(header));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                conn.disconnect();
                throw new IOException("HttpClient closed");
            }
            if (this.connection == null) {
                this.connection = conn;
            } else {
                conn.disconnect();
            }
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        HttpURLConnection conn = this.getConnection();
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("HttpClient closed");
            }
            if (this.output != null) {
                return this.output;
            }
        }
        conn.setDoOutput(true);
        OutputStream output = conn.getOutputStream();
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                output.close();
                throw new IOException("HttpClient closed");
            }
            if (this.output == null) {
                this.output = output;
            } else if (this.output != output) {
                output.close();
            }
            return this.output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer getWriter() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("HttpClient closed");
            }
            if (this.writer != null) {
                return this.writer;
            }
        }
        OutputStreamWriter writer = new OutputStreamWriter(this.getOutputStream(), "UTF-8");
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                ((Writer)writer).close();
                throw new IOException("HttpClient closed");
            }
            if (this.writer == null) {
                this.writer = writer;
            } else if (this.writer != writer) {
                ((Writer)writer).close();
            }
            return this.writer;
        }
    }

    public HttpClient writePostParam(String name, String value) throws IOException {
        HttpURLConnection conn = this.getConnection();
        if (this.output == null) {
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        Writer writer = this.getWriter();
        if (this.wrotePostParam) {
            writer.write("&");
        }
        this.wrotePostParam = true;
        writer.write(name + "=" + URLEncoder.encode(value, "UTF-8"));
        return this;
    }

    public HttpClient writeJson(Object obj) throws IOException {
        HttpURLConnection conn = this.getConnection();
        if (this.output == null) {
            conn.setRequestProperty("Content-Type", "application/json");
        }
        Writer writer = this.getWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue(writer, obj);
        return this;
    }

    public HttpClient writeString(String content) throws IOException {
        Writer writer = this.getWriter();
        writer.write(content);
        return this;
    }

    public HttpClient writeBytes(byte[] bs) throws IOException {
        OutputStream output = this.getOutputStream();
        output.write(bs);
        return this;
    }

    public HttpURLConnection getResponse() throws HttpClientException, IOException {
        this.getInputStream();
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws HttpClientException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("HttpClient closed");
            }
            if (this.input != null) {
                return this.input;
            }
            if (this.writer != null) {
                this.writer.close();
            } else if (this.output != null) {
                this.output.close();
            }
        }
        HttpURLConnection conn = this.getConnection();
        int respCode = conn.getResponseCode();
        if (respCode == -1) {
            throw new IOException("Invalid HTTP response");
        }
        String respMessage = conn.getResponseMessage();
        Map<String, List<String>> connHeaders = conn.getHeaderFields();
        this.responseHeaders = new LinkedHashMap<String, String>();
        for (String header : connHeaders.keySet()) {
            if (header == null) continue;
            StringBuilder value = new StringBuilder();
            List<String> valList = connHeaders.get(header);
            for (int i = 0; i < valList.size(); ++i) {
                if (i > 0) {
                    value.append("; ");
                }
                value.append(valList.get(i));
            }
            this.responseHeaders.put(header.toLowerCase(), value.toString());
        }
        if (respCode / 100 == 4 || respCode / 100 == 5) {
            String errorContent = "";
            InputStream errorStream = conn.getErrorStream();
            if (errorStream == null) {
                errorStream = conn.getInputStream();
            }
            if (errorStream != null) {
                try {
                    errorContent = FileUtils.readFileString(errorStream);
                }
                finally {
                    errorStream.close();
                }
            }
            throw new HttpClientException(respCode, respMessage, errorContent);
        }
        if (respCode != 200) {
            throw new HttpClientException(respCode, respMessage, "");
        }
        InputStream input = conn.getInputStream();
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                input.close();
                throw new IOException("HttpClient closed");
            }
            if (this.input == null) {
                this.input = input;
            } else if (this.input != input) {
                input.close();
            }
            return this.input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getReader() throws HttpClientException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("HttpClient closed");
            }
            if (this.reader != null) {
                return this.reader;
            }
        }
        InputStreamReader reader = new InputStreamReader(this.getInputStream(), "UTF-8");
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                ((Reader)reader).close();
                throw new IOException("HttpClient closed");
            }
            if (this.reader == null) {
                this.reader = reader;
            } else if (this.reader != reader) {
                ((Reader)reader).close();
            }
            return this.reader;
        }
    }

    public String readString() throws HttpClientException, IOException {
        return FileUtils.readFileString(this.getReader());
    }

    public <T> T readJson(Class<T> clazz) throws HttpClientException, ParseException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(this.getReader(), clazz);
        }
        catch (JsonParseException ex) {
            throw new ParseException("Can't parse JSON code: " + ex.getMessage(), ex);
        }
        catch (JsonMappingException ex) {
            throw new ParseException("Can't map JSON code to object: " + ex.getMessage(), ex);
        }
    }

    public <T> T readJson(TypeReference<T> typeRef) throws HttpClientException, ParseException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(this.getReader(), typeRef);
        }
        catch (JsonParseException ex) {
            throw new ParseException("Can't parse JSON code: " + ex.getMessage(), ex);
        }
        catch (JsonMappingException ex) {
            throw new ParseException("Can't map JSON code to object: " + ex.getMessage(), ex);
        }
    }

    public byte[] readBytes() throws HttpClientException, IOException {
        return FileUtils.readFileBytes(this.getInputStream());
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

