/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.http;

import eu.woolplatform.utils.http.URLParameters;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class OAuthUtils {
    private String consumerKey;
    private String consumerSecret;

    public OAuthUtils(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public URL buildUrl(String baseUrl, Map<String, String> params, String token, String tokenSecret) {
        LinkedHashMap<String, String> allParams = new LinkedHashMap<String, String>();
        if (params != null) {
            allParams.putAll(params);
        }
        allParams.putAll(this.getOAuthParams(token));
        this.addOAuthSignature(allParams, baseUrl, tokenSecret);
        String urlStr = baseUrl + "?" + URLParameters.getParameterString(allParams);
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Invalid URL: " + urlStr + ": " + ex.getMessage(), ex);
        }
    }

    public Map<String, String> getSignedOAuthParams(String baseUrl, String token, String tokenSecret) {
        Map<String, String> params = this.getOAuthParams(token);
        this.addOAuthSignature(params, baseUrl, tokenSecret);
        return params;
    }

    public Map<String, String> getOAuthParams(String token) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("oauth_consumer_key", this.consumerKey);
        params.put("oauth_nonce", this.generateHexKey(128));
        params.put("oauth_signature_method", "HMAC-SHA1");
        params.put("oauth_timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        if (token != null) {
            params.put("oauth_token", token);
        }
        params.put("oauth_version", "1.0");
        return params;
    }

    public void addOAuthSignature(Map<String, String> params, String baseUrl, String tokenSecret) {
        String baseString;
        String paramStr = URLParameters.getSortedParameterString(params);
        try {
            baseString = "GET&" + URLEncoder.encode(baseUrl, "UTF-8") + "&" + URLEncoder.encode(paramStr, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported: " + ex.getMessage(), ex);
        }
        String secret = this.consumerSecret + "&" + tokenSecret;
        String signature = this.getSignature(baseString, secret);
        params.put("oauth_signature", signature);
    }

    private String getSignature(String text, String secret) {
        SecretKeySpec key = new SecretKeySpec(secret.getBytes(), "HmacSHA1");
        Mac mac = null;
        GeneralSecurityException exception = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(key);
        }
        catch (NoSuchAlgorithmException ex) {
            exception = ex;
        }
        catch (InvalidKeyException ex) {
            exception = ex;
        }
        if (exception != null) {
            throw new RuntimeException("Can't init hash HmacSHA1: " + exception.getMessage(), exception);
        }
        byte[] bs = mac.doFinal(text.getBytes());
        return new String(Base64.encodeBase64((byte[])bs));
    }

    private String generateHexKey(int bits) {
        StringBuilder builder = new StringBuilder();
        byte[] bs = new byte[bits / 8];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bs);
        for (byte b : bs) {
            builder.append(String.format("%02x", b & 0xFF));
        }
        return builder.toString();
    }
}

