/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.http;

import eu.woolplatform.utils.exception.ParseException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class URLParameters {
    public static String getSortedParameterString(Map<String, String> params) {
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sortedMap.put(key, params.get(key));
        }
        return URLParameters.getParameterString(sortedMap);
    }

    public static String getParameterString(Map<String, String> params) {
        StringBuilder builder = new StringBuilder();
        for (String key : params.keySet()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            try {
                builder.append(key + "=" + URLEncoder.encode(params.get(key), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("UTF-8 not supported: " + ex.getMessage(), ex);
            }
        }
        return builder.toString();
    }

    public static Map<String, String> parseParameterString(String paramStr) throws ParseException {
        String[] paramList;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (String keyValStr : paramList = paramStr.split("&")) {
            String[] keyVal = keyValStr.split("=");
            if (keyVal.length != 2) {
                throw new ParseException("Invalid parameter string: " + paramStr);
            }
            try {
                if (keyVal[0].length() == 0) {
                    throw new ParseException("Empty key in parameter string: " + paramStr);
                }
                params.put(keyVal[0], URLDecoder.decode(keyVal[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("UTF-8 not supported: " + ex.getMessage(), ex);
            }
        }
        return params;
    }

    public static String extractParameterString(String url) {
        int startIndex = url.indexOf(63);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = url.indexOf(35, startIndex);
        if (endIndex == -1) {
            return url.substring(startIndex + 1);
        }
        return url.substring(startIndex + 1, endIndex);
    }

    public static Map<String, String> extractParameters(String url) throws ParseException {
        String paramStr = URLParameters.extractParameterString(url);
        if (paramStr == null) {
            return null;
        }
        return URLParameters.parseParameterString(paramStr);
    }
}

