/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.i18n;

import eu.woolplatform.utils.AppComponents;
import eu.woolplatform.utils.i18n.I18nResourceFinder;
import eu.woolplatform.utils.io.ClassLoaderResourceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;

public class I18n {
    private static final String LOGTAG = "I18n";
    private String baseName;
    private List<Locale> locales;
    private boolean honorifics;
    private Class<?> loadClass;
    private Properties properties;

    public I18n(String baseName, List<Locale> locales, boolean honorifics, Class<?> loadClass) throws RuntimeException {
        this.baseName = baseName;
        this.locales = locales;
        this.honorifics = honorifics;
        this.loadClass = loadClass;
        this.loadMessages();
    }

    public String get(String code) {
        return this.properties.getProperty(code, code);
    }

    private void loadMessages() throws RuntimeException {
        this.properties = null;
        I18nResourceFinder finder = new I18nResourceFinder(this.baseName);
        finder.setUserLocales(this.locales);
        finder.setHonorifics(this.honorifics);
        finder.setExtension("properties");
        finder.setResourceLocator(new ClassLoaderResourceLocator(this.loadClass));
        try {
            if (finder.find()) {
                this.properties = this.loadMessagesFromProperties(finder);
            } else {
                finder.setExtension("xml");
                if (finder.find()) {
                    this.properties = this.loadMessagesFromXml(finder);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't read message resources from " + finder.getName() + ": " + ex.getMessage(), ex);
        }
        if (this.properties == null) {
            throw new RuntimeException("No message resources found");
        }
        Logger logger = AppComponents.getLogger(LOGTAG);
        logger.info("Loaded i18n messages from resource: " + finder.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadMessagesFromProperties(I18nResourceFinder finder) throws IOException {
        Properties properties = new Properties();
        InputStream input = finder.openStream();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(input, "UTF-8");
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            } else {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadMessagesFromXml(I18nResourceFinder finder) throws IOException {
        Properties properties = new Properties();
        try (InputStream input = finder.openStream();){
            properties.loadFromXML(input);
            Properties properties2 = properties;
            return properties2;
        }
    }
}

