/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.i18n;

import eu.woolplatform.utils.i18n.I18n;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class I18nLoader {
    private static final Object STATIC_LOCK = new Object();
    private static I18nLoader instance = null;
    private final Object lock = new Object();
    private Map<I18nKey, I18n> i18nMap = new HashMap<I18nKey, I18n>();

    private I18nLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static I18nLoader getInstance() {
        Object object = STATIC_LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new I18nLoader();
            }
            return instance;
        }
    }

    public I18n getI18n(String baseName, Locale locale, boolean honorifics, Class<?> loadClass) throws RuntimeException {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(locale);
        return this.getI18n(baseName, locales, honorifics, loadClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I18n getI18n(String baseName, List<Locale> locales, boolean honorifics, Class<?> loadClass) throws RuntimeException {
        Object object = this.lock;
        synchronized (object) {
            I18nKey key = new I18nKey(baseName, locales, honorifics, loadClass);
            if (this.i18nMap.containsKey(key)) {
                return this.i18nMap.get(key);
            }
            I18n i18n = new I18n(baseName, locales, honorifics, loadClass);
            this.i18nMap.put(key, i18n);
            return i18n;
        }
    }

    private class I18nKey {
        private String baseName;
        private List<Locale> locales;
        private boolean honorifics;
        private Class<?> loadClass;

        public I18nKey(String baseName, List<Locale> locales, boolean honorifics, Class<?> loadClass) {
            this.baseName = baseName;
            this.locales = locales;
            this.honorifics = honorifics;
            this.loadClass = loadClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.baseName.hashCode();
            result = 31 * result + this.locales.hashCode();
            result = 31 * result + (this.honorifics ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            I18nKey other = (I18nKey)obj;
            if (!this.baseName.equals(other.baseName)) {
                return false;
            }
            if (!this.locales.equals(other.locales)) {
                return false;
            }
            if (this.honorifics != other.honorifics) {
                return false;
            }
            return this.loadClass == other.loadClass;
        }
    }
}

