/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.i18n;

import eu.woolplatform.utils.i18n.I18nResourceFinder;
import eu.woolplatform.utils.io.ResourceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class I18nStringMapFinder {
    private I18nResourceFinder finder;
    private Map<String, Map<String, String>> stringMaps;

    public I18nStringMapFinder(Map<String, Map<String, String>> stringMaps) {
        this.stringMaps = stringMaps;
        this.finder = new I18nResourceFinder("");
        this.finder.setExtension(null);
        this.finder.setResourceLocator(new StringMapLocator());
    }

    public void setUserLocale(Locale userLocale) {
        this.finder.setUserLocale(userLocale);
    }

    public void setUserLocales(List<Locale> userLocales) {
        this.finder.setUserLocales(userLocales);
    }

    public void setHonorifics(boolean honorifics) {
        this.finder.setHonorifics(honorifics);
    }

    public Map<String, String> find() {
        if (!this.finder.find()) {
            return new LinkedHashMap<String, String>();
        }
        return this.stringMaps.get(this.finder.getName());
    }

    private class StringMapLocator
    implements ResourceLocator {
        private StringMapLocator() {
        }

        @Override
        public boolean resourceExists(String path) {
            return I18nStringMapFinder.this.stringMaps.containsKey(path);
        }

        @Override
        public InputStream openResource(String path) throws IOException {
            return null;
        }
    }
}

