/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class BinaryReader {
    private InputStream in;
    private Charset utf;
    private int readSize = 0;

    public BinaryReader(InputStream in) {
        this.in = in;
        this.utf = Charset.forName("UTF-8");
    }

    public int getReadSize() {
        return this.readSize;
    }

    public String readString() throws EOFException, IOException {
        int len = this.readInt();
        this.readSize = 4 + len;
        byte[] bs = this.readBytes(len);
        ByteBuffer bb = ByteBuffer.wrap(bs);
        CharBuffer cb = this.utf.decode(bb);
        return cb.toString();
    }

    public String readShortString() throws EOFException, IOException {
        int len = this.readUnsignedShort();
        this.readSize = 2 + len;
        byte[] bs = this.readBytes(len);
        ByteBuffer bb = ByteBuffer.wrap(bs);
        CharBuffer cb = this.utf.decode(bb);
        return cb.toString();
    }

    public byte readByte() throws EOFException, IOException {
        this.readSize = 1;
        return this.readBytes(1)[0];
    }

    public short readUnsignedByte() throws EOFException, IOException {
        this.readSize = 1;
        byte b = this.readBytes(1)[0];
        return (short)(b & 0xFF);
    }

    public short readShort() throws EOFException, IOException {
        this.readSize = 2;
        byte[] bs = this.readBytes(2);
        short n = 0;
        for (int i = 0; i < bs.length; ++i) {
            n = (short)(n + (short)((bs[i] & 0xFF) << (1 - i) * 8));
        }
        return n;
    }

    public int readUnsignedShort() throws EOFException, IOException {
        this.readSize = 2;
        byte[] bs = this.readBytes(2);
        int n = 0;
        for (int i = 0; i < bs.length; ++i) {
            n += (bs[i] & 0xFF) << (1 - i) * 8;
        }
        return n;
    }

    public int readInt() throws EOFException, IOException {
        this.readSize = 4;
        byte[] bs = this.readBytes(4);
        int n = 0;
        for (int i = 0; i < bs.length; ++i) {
            n += (bs[i] & 0xFF) << (3 - i) * 8;
        }
        return n;
    }

    public long readUnsignedInt() throws EOFException, IOException {
        this.readSize = 4;
        byte[] bs = this.readBytes(4);
        long n = 0L;
        for (int i = 0; i < bs.length; ++i) {
            n += ((long)bs[i] & 0xFFL) << (3 - i) * 8;
        }
        return n;
    }

    public long readLong() throws EOFException, IOException {
        this.readSize = 8;
        byte[] bs = this.readBytes(8);
        long n = 0L;
        for (int i = 0; i < bs.length; ++i) {
            n += ((long)bs[i] & 0xFFL) << (7 - i) * 8;
        }
        return n;
    }

    public float readFloat() throws EOFException, IOException {
        this.readSize = 4;
        int bits = this.readInt();
        return Float.intBitsToFloat(bits);
    }

    public double readDouble() throws EOFException, IOException {
        this.readSize = 8;
        long bits = this.readLong();
        return Double.longBitsToDouble(bits);
    }

    public boolean readBoolean() throws EOFException, IOException {
        this.readSize = 1;
        int b = this.readByte() & 0xFF;
        if (b == 1) {
            return true;
        }
        if (b == 0) {
            return false;
        }
        throw new IOException("Invalid byte value for boolean: " + String.format("0x%02X", b));
    }

    private byte[] readBytes(int n) throws EOFException, IOException {
        int len;
        byte[] bs = new byte[n];
        for (int read = 0; read < n; read += len) {
            len = this.in.read(bs, read, n - read);
            if (len > 0) continue;
            throw new EOFException("End of stream");
        }
        return bs;
    }
}

