/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class BinaryWriter {
    private OutputStream out;
    private Charset utf;

    public BinaryWriter(OutputStream out) {
        this.out = out;
        this.utf = Charset.forName("UTF-8");
    }

    public void writeString(String s) throws IOException {
        ByteBuffer bb = this.utf.encode(s);
        byte[] bs = new byte[bb.remaining()];
        bb.get(bs);
        this.writeInt(bs.length);
        this.out.write(bs);
    }

    public void writeShortString(String s) throws IOException {
        ByteBuffer bb = this.utf.encode(s);
        byte[] bs = new byte[bb.remaining()];
        bb.get(bs);
        this.writeUnsignedShort(bs.length);
        this.out.write(bs);
    }

    public void writeByte(byte b) throws IOException {
        this.out.write(b & 0xFF);
    }

    public void writeUnsignedByte(short n) throws IOException {
        if ((n & 0xFF00) != 0) {
            throw new IOException("Value out of range: " + n);
        }
        this.out.write((byte)(n & 0xFF));
    }

    public void writeShort(short n) throws IOException {
        byte[] bs = new byte[2];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(n >> (1 - i) * 8 & 0xFF);
        }
        this.out.write(bs);
    }

    public void writeUnsignedShort(int n) throws IOException {
        byte[] bs = new byte[2];
        if ((n & 0xFFFF0000) != 0) {
            throw new IOException("Value out of range: " + n);
        }
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(n >> (1 - i) * 8 & 0xFF);
        }
        this.out.write(bs);
    }

    public void writeInt(int n) throws IOException {
        byte[] bs = new byte[4];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(n >> (3 - i) * 8 & 0xFF);
        }
        this.out.write(bs);
    }

    public void writeUnsignedInt(long n) throws IOException {
        byte[] bs = new byte[4];
        if ((n & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("Value out of range: " + n);
        }
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(n >> (3 - i) * 8 & 0xFFL);
        }
        this.out.write(bs);
    }

    public void writeLong(long n) throws IOException {
        byte[] bs = new byte[8];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(n >> (7 - i) * 8 & 0xFFL);
        }
        this.out.write(bs);
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBoolean(boolean b) throws IOException {
        if (b) {
            this.writeByte((byte)1);
        } else {
            this.writeByte((byte)0);
        }
    }
}

