/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.io;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private InputStream input;
    private long position = 0L;

    public CountingInputStream(InputStream input) {
        this.input = input;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public int read() throws IOException {
        int result = this.input.read();
        if (result != -1) {
            ++this.position;
        }
        return result;
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.input.read(b, off, len);
        if (result > 0) {
            this.position += (long)result;
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.input.read(b);
        if (result > 0) {
            this.position += (long)result;
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.input.skip(n);
        this.position += result;
        return result;
    }
}

