/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Random;

public class FileUtils {
    public static void mkdir(File dir) throws IOException {
        String pattern;
        File parent = dir.getParentFile();
        if (parent != null) {
            FileUtils.mkdir(parent);
        }
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException("Path is not a directory: " + dir.getAbsolutePath());
            }
            return;
        }
        String path = dir.getAbsolutePath();
        if (path.matches(pattern = FileUtils.escapePattern(File.separator + "*"))) {
            return;
        }
        if (path.matches("[A-Z]:(\\\\)*")) {
            return;
        }
        pattern = FileUtils.escapePattern(File.separator + File.separator + "[^" + File.separator + "]+(" + File.separator + "[^" + File.separator + "]+)?");
        if (path.matches(pattern)) {
            return;
        }
        if (!(dir.mkdir() || dir.exists() && dir.isDirectory())) {
            throw new IOException("Can't create directory: " + dir.getAbsolutePath());
        }
    }

    private static String escapePattern(String pattern) {
        return pattern.replaceAll("\\\\", "\\\\\\\\");
    }

    public static void truncate(File file, long len) throws IOException {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ex) {
            file = file.getAbsoluteFile();
        }
        File parent = file.getParentFile();
        if (parent == null) {
            throw new IOException("Can't get parent of file: " + file.getAbsolutePath());
        }
        String filename = file.getName();
        File tempFile = FileUtils.createTempFile(parent, filename, "temp");
        FileUtils.copyFile(file, tempFile);
        long toCopy = tempFile.length();
        if (toCopy > len) {
            toCopy = len;
        }
        FileUtils.copyFile(tempFile, file, 0L, toCopy);
        tempFile.delete();
    }

    public static File createTempFile(File dir, String prefix, String ext) throws IOException {
        int start;
        try {
            dir = dir.getCanonicalFile();
        }
        catch (IOException ex) {
            dir = dir.getAbsoluteFile();
        }
        Random random = new Random();
        int n = start = random.nextInt();
        do {
            String filename;
            File f;
            if ((f = new File(dir, filename = prefix + "." + String.format("%08X", n) + "." + ext)).exists() || !f.createNewFile()) continue;
            return f;
        } while (++n != start);
        throw new IOException("Can't find free file name for temporary file in directory: " + dir.getAbsolutePath());
    }

    public static void copyFile(File source, File dest) throws IOException {
        FileUtils.copyFile(source, dest, 0L, source.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest, long start, long len) throws IOException {
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(dest);){
            FileUtils.copyStream(in, out, start, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(URL source, File dest) throws IOException {
        try (InputStream in = source.openStream();
             FileOutputStream out = new FileOutputStream(dest);){
            FileUtils.copyStream(in, out, 0L, null);
        }
    }

    private static void copyStream(InputStream in, OutputStream out, long start, Long len) throws IOException {
        long currSkipped;
        for (long skipped = 0L; skipped < start; skipped += currSkipped) {
            currSkipped = in.skip(start - skipped);
            if (currSkipped > 0L) continue;
            throw new EOFException("End of file");
        }
        int nread = 0;
        byte[] bs = new byte[1024];
        while (len == null || (long)nread < len) {
            Long toRead = null;
            if (len != null && (toRead = Long.valueOf(len - (long)nread)) > (long)bs.length) {
                toRead = bs.length;
            }
            int n = len == null ? in.read(bs) : in.read(bs, 0, toRead.intValue());
            if (len == null && n <= 0) {
                return;
            }
            if (n <= 0) {
                throw new EOFException("End of file");
            }
            out.write(bs, 0, n);
            nread += n;
        }
    }

    public static void deleteTree(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            File[] children;
            for (File f : children = dir.listFiles()) {
                FileUtils.deleteTree(f);
            }
            if (!dir.delete()) {
                throw new IOException("Can't delete directory: " + dir.getAbsolutePath());
            }
        } else if (!dir.delete()) {
            throw new IOException("Can't delete file: " + dir.getAbsolutePath());
        }
    }

    public static void clearDirectory(File dir) throws IOException {
        File[] children;
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new IOException("Path is not a directory: " + dir.getAbsolutePath());
        }
        for (File child : children = dir.listFiles()) {
            FileUtils.deleteTree(child);
        }
    }

    public static byte[] readFileBytes(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            byte[] byArray = FileUtils.readFileBytes(input);
            return byArray;
        }
    }

    public static byte[] readFileBytes(URL url) throws IOException {
        try (InputStream input = url.openStream();){
            byte[] byArray = FileUtils.readFileBytes(input);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileBytes(InputStream input) throws IOException {
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            int len;
            byte[] bs = new byte[2048];
            while ((len = input.read(bs)) > 0) {
                byteOut.write(bs, 0, len);
            }
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
    }

    public static String readFileString(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            String string = FileUtils.readFileString(input);
            return string;
        }
    }

    public static String readFileString(URL url) throws IOException {
        try (InputStream input = url.openStream();){
            String string = FileUtils.readFileString(input);
            return string;
        }
    }

    public static String readFileString(InputStream input) throws IOException {
        return FileUtils.readFileString(new InputStreamReader(input, "UTF-8"));
    }

    public static String readFileString(Reader reader) throws IOException {
        int len;
        StringBuilder builder = new StringBuilder();
        char[] cs = new char[2048];
        while ((len = reader.read(cs)) > 0) {
            builder.append(cs, 0, len);
        }
        return builder.toString();
    }

    public static void writeFileString(File file, String content) throws IOException {
        try (FileOutputStream output = new FileOutputStream(file);){
            FileUtils.writeFileString(output, content);
        }
    }

    public static void writeFileString(OutputStream output, String content) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");){
            writer.write(content);
        }
    }
}

