/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.io;

public class WritableByteBuffer {
    private byte[] buffer;
    private int start;
    private int size;

    public WritableByteBuffer(int capacity) {
        this.buffer = new byte[capacity];
        this.start = 0;
        this.size = 0;
    }

    public WritableByteBuffer(WritableByteBuffer other) {
        this.buffer = new byte[other.buffer.length];
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = other.buffer[i];
        }
        this.start = other.start;
        this.size = other.size;
    }

    public byte get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + index + " in byte buffer with size " + this.size);
        }
        int bufferIndex = (this.start + index) % this.buffer.length;
        return this.buffer[bufferIndex];
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.start = 0;
        this.size = 0;
    }

    public void append(byte b) {
        if (this.size == this.buffer.length) {
            this.increaseBuffer();
        }
        int index = (this.start + this.size) % this.buffer.length;
        this.buffer[index] = b;
        ++this.size;
    }

    public void append(byte[] bs, int off, int len) {
        int newSize = this.size + len;
        while (this.buffer.length < newSize) {
            this.increaseBuffer();
        }
        int index = (this.start + this.size) % this.buffer.length;
        for (int i = 0; i < len; ++i) {
            this.buffer[index] = bs[off + i];
            if (++index != this.buffer.length) continue;
            index = 0;
        }
        this.size = newSize;
    }

    public void append(WritableByteBuffer other, int off, int len) {
        int newSize = this.size + len;
        while (this.buffer.length < newSize) {
            this.increaseBuffer();
        }
        int index = (this.start + this.size) % this.buffer.length;
        int otherIndex = (other.start + off) % other.buffer.length;
        for (int i = 0; i < len; ++i) {
            this.buffer[index] = other.buffer[otherIndex];
            if (++index == this.buffer.length) {
                index = 0;
            }
            if (++otherIndex != other.buffer.length) continue;
            otherIndex = 0;
        }
        this.size = newSize;
    }

    public void removeHead(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("Can't remove " + n + " bytes from byte buffer with size " + this.size);
        }
        this.size -= n;
        this.start = this.size == 0 ? 0 : (this.start + n) % this.buffer.length;
    }

    public byte removeFirst() {
        byte b = this.get(0);
        this.removeHead(1);
        return b;
    }

    private void increaseBuffer() {
        byte[] newBuffer = new byte[2 * this.buffer.length];
        int oldIndex = this.start;
        for (int i = 0; i < this.size; ++i) {
            newBuffer[i] = this.buffer[oldIndex];
            if (++oldIndex != this.buffer.length) continue;
            oldIndex = 0;
        }
        this.buffer = newBuffer;
        this.start = 0;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.size];
        int index = this.start;
        for (int i = 0; i < this.size; ++i) {
            result[i] = this.buffer[index];
            if (++index != this.buffer.length) continue;
            index = 0;
        }
        return result;
    }

    public Object clone() {
        return new WritableByteBuffer(this);
    }
}

