/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.io;

import eu.woolplatform.utils.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int COPY_BUFFER_SIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File outputDir) throws IOException {
        FileUtils.mkdir(outputDir);
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            byte[] bs = new byte[2048];
            while ((entry = zipIn.getNextEntry()) != null) {
                try {
                    File outFile = new File(outputDir, entry.getName());
                    try (FileOutputStream output = new FileOutputStream(outFile);){
                        int len;
                        while ((len = zipIn.read(bs)) > 0) {
                            output.write(bs, 0, len);
                        }
                    }
                    outFile.setLastModified(entry.getTime());
                }
                finally {
                    zipIn.closeEntry();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File srcFile, File zipFile) throws IOException {
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));){
            ZipEntry entry = new ZipEntry(srcFile.getName());
            entry.setTime(srcFile.lastModified());
            try (FileInputStream input = new FileInputStream(srcFile);){
                ZipUtils.addZipFile(entry, input, zipOut);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFileSet(File rootDir, List<File> files, File zipFile) throws IOException {
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));){
            for (File file : files) {
                ZipEntry entry = new ZipEntry(ZipUtils.getRelativePath(rootDir, file));
                entry.setTime(file.lastModified());
                try (FileInputStream input = new FileInputStream(file);){
                    ZipUtils.addZipFile(entry, input, zipOut);
                }
            }
        }
    }

    private static void addZipFile(ZipEntry entry, InputStream source, ZipOutputStream zipOut) throws IOException {
        int len;
        zipOut.putNextEntry(entry);
        byte[] bs = new byte[2048];
        while ((len = source.read(bs)) > 0) {
            zipOut.write(bs, 0, len);
        }
        zipOut.closeEntry();
    }

    private static String getRelativePath(File dir, File file) throws IOException {
        dir = dir.getCanonicalFile();
        file = file.getCanonicalFile();
        ArrayList<String> path = new ArrayList<String>();
        path.add(file.getName());
        File parent = file.getParentFile();
        while (parent != null && !parent.equals(dir)) {
            path.add(0, parent.getName());
        }
        StringBuilder pathStr = new StringBuilder();
        boolean first = true;
        for (String component : path) {
            if (!first) {
                pathStr.append("/");
            }
            first = false;
            pathStr.append(component);
        }
        return pathStr.toString();
    }
}

