/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EnumCodeDeserializer<T extends Enum<?>>
extends JsonDeserializer<T> {
    private Class<T> enumClass;

    public EnumCodeDeserializer(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        int code = p.getIntValue();
        Exception exception = null;
        Enum result = null;
        try {
            Method method = this.enumClass.getMethod("forCode", Integer.TYPE);
            Object resultObj = method.invoke(null, code);
            result = (Enum)this.enumClass.cast(resultObj);
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
        }
        catch (InvocationTargetException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        catch (IllegalArgumentException ex) {
            exception = ex;
        }
        if (exception != null) {
            throw new RuntimeException("Can't invoke forCode(): " + exception.getMessage(), exception);
        }
        return (T)result;
    }
}

