/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EnumCodeSerializer
extends JsonSerializer<Enum<?>> {
    public void serialize(Enum<?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        int code = 0;
        Exception exception = null;
        try {
            Method method = value.getClass().getMethod("code", new Class[0]);
            code = (Integer)method.invoke(value, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
        }
        catch (InvocationTargetException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        catch (IllegalArgumentException ex) {
            exception = ex;
        }
        if (exception != null) {
            throw new RuntimeException("Can't invoke code(): " + exception.getMessage(), exception);
        }
        gen.writeNumber(code);
    }
}

