/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EnumCustomStringDeserializer<T extends Enum<?>>
extends JsonDeserializer<T> {
    private Class<T> enumClass;

    public EnumCustomStringDeserializer(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!p.getCurrentToken().isScalarValue()) {
            throw new JsonParseException(p, "Expected string, found non-scalar value");
        }
        String s = p.getValueAsString();
        if (s == null) {
            return null;
        }
        Exception exception = null;
        Enum result = null;
        try {
            Method method = this.enumClass.getMethod("fromStringValue", String.class);
            Object resultObj = method.invoke(null, s);
            result = (Enum)this.enumClass.cast(resultObj);
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
        }
        catch (InvocationTargetException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        catch (IllegalArgumentException ex) {
            exception = ex;
        }
        if (exception != null) {
            throw new RuntimeException("Can't invoke fromStringValue(): " + exception.getMessage(), exception);
        }
        return (T)result;
    }
}

