/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.woolplatform.utils.exception.ParseException;
import java.io.IOException;

public class JsonMapper {
    public static <T> T parse(String json, Class<T> clazz) throws ParseException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (JsonParseException ex) {
            throw new ParseException("Can't parse JSON code: " + ex.getMessage(), ex);
        }
        catch (JsonMappingException ex) {
            throw new ParseException("Can't map JSON code to object: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("I/O error when reading from string: " + ex.getMessage(), ex);
        }
    }

    public static <T> T parse(String json, TypeReference<T> typeRef) throws ParseException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, typeRef);
        }
        catch (JsonParseException ex) {
            throw new ParseException("Can't parse JSON code: " + ex.getMessage(), ex);
        }
        catch (JsonMappingException ex) {
            throw new ParseException("Can't map JSON code to object: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("I/O error when reading from string: " + ex.getMessage(), ex);
        }
    }

    public static <T> T convert(Object json, Class<T> clazz) throws ParseException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.convertValue(json, clazz);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("Can't map JSON code to object: " + ex.getMessage(), ex);
        }
    }

    public static <T> T convert(Object json, TypeReference<T> typeRef) throws ParseException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.convertValue(json, typeRef);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("Can't map JSON code to object: " + ex.getMessage(), ex);
        }
    }

    public static String generate(Object obj) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Can't convert object to JSON: " + ex.getMessage(), ex);
        }
    }
}

