/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json;

import eu.woolplatform.utils.json.JsonAtomicToken;
import eu.woolplatform.utils.json.JsonParseException;
import eu.woolplatform.utils.json.JsonStreamReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonObjectStreamReader
implements Closeable {
    private JsonStreamReader reader;

    public JsonObjectStreamReader(InputStream input) {
        this.reader = new JsonStreamReader(input);
    }

    public JsonObjectStreamReader(Reader reader) {
        this.reader = new JsonStreamReader(reader);
    }

    public JsonObjectStreamReader(JsonStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public int getDocumentLine() {
        return this.reader.getDocumentLine();
    }

    public int getDocumentLinePos() {
        return this.reader.getDocumentLinePos();
    }

    public int getTokenStartLine() {
        return this.reader.getTokenStartLine();
    }

    public int getTokenStartLinePos() {
        return this.reader.getTokenStartLinePos();
    }

    public JsonAtomicToken getToken() throws JsonParseException, IOException {
        if (!this.moveToToken()) {
            return null;
        }
        return this.reader.getToken();
    }

    public JsonAtomicToken readToken() throws JsonParseException, IOException {
        if (!this.moveToToken()) {
            return null;
        }
        JsonAtomicToken token = this.reader.getToken();
        this.reader.moveNext();
        return token;
    }

    public JsonAtomicToken readToken(JsonAtomicToken.Type type) throws JsonParseException, IOException {
        this.validateCurrentToken(type);
        return this.readToken();
    }

    private JsonAtomicToken validateCurrentToken(JsonAtomicToken.Type type) throws JsonParseException, IOException {
        if (!this.moveToToken()) {
            throw new JsonParseException("Expected token " + (Object)((Object)type) + ", found end of document", this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        JsonAtomicToken token = this.reader.getToken();
        if (token.getType() != type) {
            throw new JsonParseException("Expected token " + (Object)((Object)type) + ", found " + (Object)((Object)token.getType()), this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        return token;
    }

    public String readString() throws JsonParseException, IOException {
        if (this.reader.isStringAtomic()) {
            JsonAtomicToken token = this.readToken(JsonAtomicToken.Type.STRING);
            return (String)token.getValue();
        }
        StringBuilder builder = new StringBuilder();
        this.readToken(JsonAtomicToken.Type.START_STRING);
        JsonAtomicToken token = this.readToken();
        while (token.getType() != JsonAtomicToken.Type.END_STRING) {
            builder.append((String)token.getValue());
            token = this.readToken();
        }
        return builder.toString();
    }

    public byte readByte() throws JsonParseException, IOException {
        JsonAtomicToken token = this.validateCurrentToken(JsonAtomicToken.Type.NUMBER);
        if (token.getValue() instanceof Double) {
            throw new JsonParseException("Number is not a byte: " + token.getValue(), this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        long val = ((Number)token.getValue()).longValue();
        if (val < -128L || val > 127L) {
            throw new JsonParseException("Number value out of byte range: " + val, this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        this.readToken();
        return (byte)val;
    }

    public short readShort() throws JsonParseException, IOException {
        JsonAtomicToken token = this.validateCurrentToken(JsonAtomicToken.Type.NUMBER);
        if (token.getValue() instanceof Double) {
            throw new JsonParseException("Number is not a short: " + token.getValue(), this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        long val = ((Number)token.getValue()).longValue();
        if (val < -32768L || val > 32767L) {
            throw new JsonParseException("Number value out of short range: " + val, this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        this.readToken();
        return (short)val;
    }

    public int readInt() throws JsonParseException, IOException {
        JsonAtomicToken token = this.validateCurrentToken(JsonAtomicToken.Type.NUMBER);
        if (token.getValue() instanceof Double) {
            throw new JsonParseException("Number is not an int: " + token.getValue(), this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        long val = ((Number)token.getValue()).longValue();
        if (val < Integer.MIN_VALUE || val > Integer.MAX_VALUE) {
            throw new JsonParseException("Number value out of int range: " + val, this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        this.readToken();
        return (int)val;
    }

    public long readLong() throws JsonParseException, IOException {
        JsonAtomicToken token = this.validateCurrentToken(JsonAtomicToken.Type.NUMBER);
        if (token.getValue() instanceof Double) {
            throw new JsonParseException("Number is not a long: " + token.getValue(), this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        this.readToken();
        return ((Number)token.getValue()).longValue();
    }

    public float readFloat() throws JsonParseException, IOException {
        JsonAtomicToken token = this.readToken(JsonAtomicToken.Type.NUMBER);
        return ((Number)token.getValue()).floatValue();
    }

    public double readDouble() throws JsonParseException, IOException {
        JsonAtomicToken token = this.readToken(JsonAtomicToken.Type.NUMBER);
        return ((Number)token.getValue()).doubleValue();
    }

    public boolean readBoolean() throws JsonParseException, IOException {
        JsonAtomicToken token = this.readToken(JsonAtomicToken.Type.BOOLEAN);
        return (Boolean)token.getValue();
    }

    public Map<String, ?> readObject() throws JsonParseException, IOException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.readToken(JsonAtomicToken.Type.START_OBJECT);
        while (this.reader.getToken().getType() != JsonAtomicToken.Type.END_OBJECT) {
            String key = this.readString();
            this.readToken(JsonAtomicToken.Type.OBJECT_KEY_VALUE_SEPARATOR);
            result.put(key, this.readValue());
            if (this.reader.getToken().getType() != JsonAtomicToken.Type.OBJECT_PAIR_SEPARATOR) continue;
            this.readToken();
        }
        this.readToken();
        return result;
    }

    public List<?> readList() throws JsonParseException, IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        this.readToken(JsonAtomicToken.Type.START_LIST);
        while (this.reader.getToken().getType() != JsonAtomicToken.Type.END_LIST) {
            result.add(this.readValue());
            if (this.reader.getToken().getType() != JsonAtomicToken.Type.LIST_ITEM_SEPARATOR) continue;
            this.readToken();
        }
        this.readToken();
        return result;
    }

    public Object readValue() throws JsonParseException, IOException {
        if (!this.moveToToken()) {
            throw new JsonParseException("End of document", this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
        }
        JsonAtomicToken token = this.reader.getToken();
        switch (token.getType()) {
            case STRING: 
            case START_STRING: {
                return this.readString();
            }
            case NUMBER: {
                token = this.readToken(JsonAtomicToken.Type.NUMBER);
                return token.getValue();
            }
            case BOOLEAN: {
                return this.readBoolean();
            }
            case NULL: {
                this.readToken(JsonAtomicToken.Type.NULL);
                return null;
            }
            case START_OBJECT: {
                return this.readObject();
            }
            case START_LIST: {
                return this.readList();
            }
        }
        throw new JsonParseException("Expected start of value, found token " + (Object)((Object)token.getType()), this.reader.getDocumentLine(), this.reader.getDocumentLinePos());
    }

    private boolean moveToToken() throws JsonParseException, IOException {
        if (this.reader.getToken() == null) {
            return this.reader.moveNext();
        }
        return true;
    }
}

