/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json;

import eu.woolplatform.utils.json.JsonAtomicToken;
import eu.woolplatform.utils.json.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsonStreamReader {
    private static final int BUFFER_SIZE = 1024;
    private boolean isStringAtomic = true;
    private Reader reader;
    private boolean endOfStream = false;
    private StringBuilder parsedBoolean = null;
    private StringBuilder parsedNull = null;
    private StringBuilder parsedNumber = null;
    private JsonAtomicToken currentToken = null;
    private char[] buffer = new char[1024];
    private int bufferPos = 0;
    private int bufferLen = 0;
    private int documentLine = 1;
    private int documentLinePos = 1;
    private int tokenStartLine = 1;
    private int tokenStartLinePos = 1;
    private boolean consumedCR = false;
    private NumberPos numberPos = null;
    private List<ObjectList> objectListStack = new ArrayList<ObjectList>();
    private StringBuilder stringEscape = null;
    private StringBuilder parsedString = null;
    private boolean inObjectKey = false;

    public JsonStreamReader(InputStream input) {
        this.reader = new InputStreamReader(input, StandardCharsets.UTF_8);
    }

    public JsonStreamReader(Reader reader) {
        this.reader = reader;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void setIsStringAtomic(boolean isStringAtomic) {
        this.isStringAtomic = isStringAtomic;
    }

    public boolean isStringAtomic() {
        return this.isStringAtomic;
    }

    public int getDocumentLine() {
        return this.documentLine;
    }

    public int getDocumentLinePos() {
        return this.documentLinePos;
    }

    public int getTokenStartLine() {
        return this.tokenStartLine;
    }

    public int getTokenStartLinePos() {
        return this.tokenStartLinePos;
    }

    public boolean moveNext() throws JsonParseException, IOException {
        block9: while (true) {
            if (this.endOfStream) {
                if (this.currentToken != null) {
                    return this.finishStream();
                }
                return false;
            }
            if (this.bufferLen == 0) {
                this.bufferPos = 0;
                int len = this.reader.read(this.buffer);
                if (len <= 0) {
                    this.bufferLen = 0;
                    this.endOfStream = true;
                    return this.finishStream();
                }
                this.bufferLen = len;
            }
            block10: while (true) {
                if (this.bufferLen <= 0) continue block9;
                char c = this.buffer[this.bufferPos];
                if (this.parsedString != null) {
                    if (!this.parseStringChar(c)) continue;
                    return true;
                }
                if (this.parsedNumber != null) {
                    if (!this.parseNumberChar(c)) continue;
                    return true;
                }
                if (this.parsedBoolean != null) {
                    if (!this.parseBooleanChar(c)) continue;
                    return true;
                }
                if (this.parsedNull != null) {
                    if (!this.parseNullChar(c)) continue;
                    return true;
                }
                if (this.currentToken == null) {
                    if (!this.parseValueInitial(c)) continue;
                    return true;
                }
                switch (this.currentToken.getType()) {
                    case START_OBJECT: {
                        if (!this.parseStartObject(c)) break;
                        return true;
                    }
                    case OBJECT_PAIR_SEPARATOR: {
                        if (!this.parseObjectKey(c)) break;
                        return true;
                    }
                    case START_LIST: {
                        if (!this.parseStartList(c)) break;
                        return true;
                    }
                    case OBJECT_KEY_VALUE_SEPARATOR: 
                    case LIST_ITEM_SEPARATOR: {
                        if (!this.parseValueInitial(c)) break;
                        return true;
                    }
                    case START_STRING: 
                    case STRING_CHARACTER: {
                        if (!this.parseStringChar(c)) break;
                        return true;
                    }
                    case END_STRING: 
                    case STRING: {
                        if (!(this.inObjectKey ? this.parseAfterObjectKey(c) : this.parseAfterValue(c))) continue block10;
                        return true;
                    }
                    case END_OBJECT: 
                    case END_LIST: 
                    case NUMBER: 
                    case BOOLEAN: 
                    case NULL: {
                        if (!this.parseAfterValue(c)) break;
                        return true;
                    }
                }
            }
            break;
        }
    }

    public JsonAtomicToken getToken() {
        return this.currentToken;
    }

    private boolean parseValueInitial(char c) throws JsonParseException {
        if (Character.isWhitespace(c)) {
            this.consumeCharacter(c);
            return false;
        }
        if (c == '{') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.START_OBJECT);
            this.objectListStack.add(ObjectList.OBJECT);
            return true;
        }
        if (c == '[') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.START_LIST);
            this.objectListStack.add(ObjectList.LIST);
            return true;
        }
        if (c == '\"') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            if (this.isStringAtomic) {
                this.parsedString = new StringBuilder();
                return false;
            }
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.START_STRING);
            return true;
        }
        if (c == 't' || c == 'f') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.parsedBoolean = new StringBuilder();
            this.parsedBoolean.append(c);
            return false;
        }
        if (c == 'n') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.parsedNull = new StringBuilder();
            this.parsedNull.append(c);
            return false;
        }
        this.tokenStartLine = this.documentLine;
        this.tokenStartLinePos = this.documentLinePos;
        return this.parseNumberChar(c);
    }

    private boolean parseStartObject(char c) throws JsonParseException {
        if (Character.isWhitespace(c)) {
            this.consumeCharacter(c);
            return false;
        }
        if (c == '\"') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.inObjectKey = true;
            if (this.isStringAtomic) {
                this.parsedString = new StringBuilder();
                return false;
            }
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.START_STRING);
            return true;
        }
        if (c == '}') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.END_OBJECT);
            this.objectListStack.remove(this.objectListStack.size() - 1);
            return true;
        }
        throw new JsonParseException("Invalid character after start object: " + c, this.documentLine, this.documentLinePos);
    }

    private boolean parseObjectKey(char c) throws JsonParseException {
        if (Character.isWhitespace(c)) {
            this.consumeCharacter(c);
            return false;
        }
        if (c == '\"') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.inObjectKey = true;
            if (this.isStringAtomic) {
                this.parsedString = new StringBuilder();
                return false;
            }
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.START_STRING);
            return true;
        }
        throw new JsonParseException("Expected start of object key, found: " + c, this.documentLine, this.documentLinePos);
    }

    private boolean parseAfterObjectKey(char c) throws JsonParseException {
        if (Character.isWhitespace(c)) {
            this.consumeCharacter(c);
            return false;
        }
        if (c == ':') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.OBJECT_KEY_VALUE_SEPARATOR);
            this.inObjectKey = false;
            return true;
        }
        throw new JsonParseException("Invalid character after object key: " + c, this.documentLine, this.documentLinePos);
    }

    private boolean parseStartList(char c) throws JsonParseException {
        if (Character.isWhitespace(c)) {
            this.consumeCharacter(c);
            return false;
        }
        if (c == ']') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.END_LIST);
            this.objectListStack.remove(this.objectListStack.size() - 1);
            return true;
        }
        return this.parseValueInitial(c);
    }

    private boolean parseStringChar(char c) throws JsonParseException {
        if (this.stringEscape != null && this.stringEscape.length() == 1) {
            char escapedChar;
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    escapedChar = c;
                    break;
                }
                case 'b': {
                    escapedChar = '\b';
                    break;
                }
                case 'f': {
                    escapedChar = '\f';
                    break;
                }
                case 'n': {
                    escapedChar = '\n';
                    break;
                }
                case 'r': {
                    escapedChar = '\r';
                    break;
                }
                case 't': {
                    escapedChar = '\t';
                    break;
                }
                case 'u': {
                    this.stringEscape.append(c);
                    this.consumeCharacter(c);
                    return false;
                }
                default: {
                    throw new JsonParseException("Invalid string escape sequence: " + this.stringEscape + c, this.documentLine, this.documentLinePos);
                }
            }
            this.consumeCharacter(c);
            this.stringEscape = null;
            if (this.isStringAtomic) {
                this.parsedString.append(escapedChar);
                return false;
            }
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.STRING_CHARACTER, Character.toString(escapedChar));
            return true;
        }
        if (this.stringEscape != null) {
            String charStr = Character.toString(c);
            if (!charStr.matches("[0-9A-Fa-f]")) {
                throw new JsonParseException("Invalid string escape sequence: " + this.stringEscape + c, this.documentLine, this.documentLinePos);
            }
            this.consumeCharacter(c);
            this.stringEscape.append(c);
            if (this.stringEscape.length() < 6) {
                return false;
            }
            String hex = this.stringEscape.substring(2);
            int codePoint = Integer.parseInt(hex, 16);
            char[] cs = Character.toChars(codePoint);
            this.stringEscape = null;
            if (this.isStringAtomic) {
                this.parsedString.append(cs);
                return false;
            }
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.STRING_CHARACTER, new String(cs));
            return true;
        }
        if (c == '\"') {
            if (!this.isStringAtomic) {
                this.tokenStartLine = this.documentLine;
                this.tokenStartLinePos = this.documentLinePos;
            }
            this.consumeCharacter(c);
            if (this.isStringAtomic) {
                this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.STRING, this.parsedString.toString());
                this.parsedString = null;
            } else {
                this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.END_STRING);
            }
            return true;
        }
        if (c == '\\') {
            if (!this.isStringAtomic) {
                this.tokenStartLine = this.documentLine;
                this.tokenStartLinePos = this.documentLinePos;
            }
            this.consumeCharacter(c);
            this.stringEscape = new StringBuilder();
            this.stringEscape.append(c);
            return false;
        }
        if (!Character.isISOControl(c)) {
            if (!this.isStringAtomic) {
                this.tokenStartLine = this.documentLine;
                this.tokenStartLinePos = this.documentLinePos;
            }
            this.consumeCharacter(c);
            if (this.isStringAtomic) {
                this.parsedString.append(c);
                return false;
            }
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.STRING_CHARACTER, Character.toString(c));
            return true;
        }
        throw new JsonParseException(String.format("Control character not allowed: 0x%02x", c), this.documentLine, this.documentLinePos);
    }

    private boolean parseAfterValue(char c) throws JsonParseException {
        if (Character.isWhitespace(c)) {
            this.consumeCharacter(c);
            return false;
        }
        if (this.objectListStack.isEmpty()) {
            throw new JsonParseException("Unxpected character after root value: " + c, this.documentLine, this.documentLinePos);
        }
        ObjectList currObjectList = this.objectListStack.get(this.objectListStack.size() - 1);
        if (currObjectList == ObjectList.LIST) {
            if (c == ',') {
                this.tokenStartLine = this.documentLine;
                this.tokenStartLinePos = this.documentLinePos;
                this.consumeCharacter(c);
                this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.LIST_ITEM_SEPARATOR);
                return true;
            }
            if (c == ']') {
                this.tokenStartLine = this.documentLine;
                this.tokenStartLinePos = this.documentLinePos;
                this.consumeCharacter(c);
                this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.END_LIST);
                this.objectListStack.remove(this.objectListStack.size() - 1);
                return true;
            }
            throw new JsonParseException("Invalid character after list item: " + c, this.documentLine, this.documentLinePos);
        }
        if (c == ',') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.OBJECT_PAIR_SEPARATOR);
            return true;
        }
        if (c == '}') {
            this.tokenStartLine = this.documentLine;
            this.tokenStartLinePos = this.documentLinePos;
            this.consumeCharacter(c);
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.END_OBJECT);
            this.objectListStack.remove(this.objectListStack.size() - 1);
            return true;
        }
        throw new JsonParseException("Invalid character after key/value pair in object: " + c, this.documentLine, this.documentLinePos);
    }

    private boolean parseBooleanChar(char c) throws JsonParseException {
        String expected = this.parsedBoolean.charAt(0) == 't' ? "true" : "false";
        char expectedChar = expected.charAt(this.parsedBoolean.length());
        if (c != expectedChar) {
            throw new JsonParseException("Invalid token: " + this.parsedBoolean + c, this.documentLine, this.documentLinePos);
        }
        this.parsedBoolean.append(c);
        this.consumeCharacter(c);
        if (this.parsedBoolean.length() == expected.length()) {
            this.parsedBoolean = null;
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.BOOLEAN, expected.equals("true"));
            return true;
        }
        return false;
    }

    private boolean parseNullChar(char c) throws JsonParseException {
        String expected = "null";
        char expectedChar = expected.charAt(this.parsedNull.length());
        if (c != expectedChar) {
            throw new JsonParseException("Invalid token: " + this.parsedNull + c, this.documentLine, this.documentLinePos);
        }
        this.parsedNull.append(c);
        this.consumeCharacter(c);
        if (this.parsedNull.length() == expected.length()) {
            this.parsedNull = null;
            this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.NULL);
            return true;
        }
        return false;
    }

    private boolean parseNumberChar(char c) throws JsonParseException {
        if (this.numberPos == null) {
            this.numberPos = NumberPos.START;
        }
        switch (this.numberPos) {
            case START: {
                if (c == '-') {
                    this.consumeCharacter(c);
                    this.parsedNumber = new StringBuilder();
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.AFTER_MAIN_SIGN;
                    return false;
                }
                if (c == '0') {
                    this.consumeCharacter(c);
                    this.parsedNumber = new StringBuilder();
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.AFTER_MAIN;
                    return false;
                }
                if (c >= '1' && c <= '9') {
                    this.consumeCharacter(c);
                    this.parsedNumber = new StringBuilder();
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.IN_MAIN;
                    return false;
                }
                throw new JsonParseException("Invalid character at start of value: " + c, this.documentLine, this.documentLinePos);
            }
            case AFTER_MAIN_SIGN: {
                if (c == '0') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.AFTER_MAIN;
                    return false;
                }
                if (c >= '1' && c <= '9') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.IN_MAIN;
                    return false;
                }
                throw new JsonParseException("Invalid number: " + this.parsedNumber + c, this.documentLine, this.documentLinePos);
            }
            case AFTER_MAIN: {
                if (c == '.') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.AFTER_POINT;
                    return false;
                }
                if (c == 'e' || c == 'E') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.AFTER_EXP;
                    return false;
                }
                this.finishNumber();
                return true;
            }
            case IN_MAIN: {
                if (c >= '0' && c <= '9') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    return false;
                }
                if (c == '.') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.AFTER_POINT;
                    return false;
                }
                if (c == 'e' || c == 'E') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.AFTER_EXP;
                    return false;
                }
                this.finishNumber();
                return true;
            }
            case AFTER_POINT: {
                if (c >= '0' && c <= '9') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.IN_FRACTION;
                    return false;
                }
                throw new JsonParseException("Invalid number: " + this.parsedNumber + c, this.documentLine, this.documentLinePos);
            }
            case IN_FRACTION: {
                if (c >= '0' && c <= '9') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    return false;
                }
                if (c == 'e' || c == 'E') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.AFTER_EXP;
                    return false;
                }
                this.finishNumber();
                return true;
            }
            case AFTER_EXP: {
                if (c == '+' || c == '-') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.AFTER_EXP_SIGN;
                    return false;
                }
                if (c >= '0' && c <= '9') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.IN_EXP_NUMBER;
                    return false;
                }
                throw new JsonParseException("Invalid number: " + this.parsedNumber + c, this.documentLine, this.documentLinePos);
            }
            case AFTER_EXP_SIGN: {
                if (c >= '0' && c <= '9') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.IN_EXP_NUMBER;
                    return false;
                }
                throw new JsonParseException("Invalid number: " + this.parsedNumber + c, this.documentLine, this.documentLinePos);
            }
            case IN_EXP_NUMBER: {
                if (c >= '0' && c <= '9') {
                    this.consumeCharacter(c);
                    this.parsedNumber.append(c);
                    this.numberPos = NumberPos.IN_EXP_NUMBER;
                    return false;
                }
                this.finishNumber();
                return true;
            }
        }
        throw new RuntimeException("Unknown number position: " + (Object)((Object)this.numberPos));
    }

    private void finishNumber() throws JsonParseException {
        long longVal;
        List<NumberPos> endStates = Arrays.asList(NumberPos.AFTER_MAIN, NumberPos.IN_MAIN, NumberPos.IN_FRACTION, NumberPos.IN_EXP_NUMBER);
        if (!endStates.contains((Object)this.numberPos)) {
            throw new JsonParseException("Invalid number: " + this.parsedNumber, this.documentLine, this.documentLinePos);
        }
        Number value = this.numberPos == NumberPos.AFTER_MAIN || this.numberPos == NumberPos.IN_MAIN ? (Number)((longVal = Long.parseLong(this.parsedNumber.toString())) >= Integer.MIN_VALUE && longVal <= Integer.MAX_VALUE ? (Number)((int)longVal) : (Number)longVal) : (Number)Double.parseDouble(this.parsedNumber.toString());
        this.currentToken = new JsonAtomicToken(JsonAtomicToken.Type.NUMBER, value);
        this.parsedNumber = null;
        this.numberPos = null;
    }

    private boolean finishStream() throws JsonParseException {
        if (this.parsedString != null) {
            throw new JsonParseException("Incomplete string at end of document", this.documentLine, this.documentLinePos);
        }
        if (this.parsedNumber != null) {
            this.finishNumber();
            return true;
        }
        if (this.parsedBoolean != null) {
            throw new JsonParseException("Incomplete token at end of document: " + this.parsedBoolean, this.documentLine, this.documentLinePos);
        }
        if (this.parsedNull != null) {
            throw new JsonParseException("Incomplete token at end of document: " + this.parsedNull, this.documentLine, this.documentLinePos);
        }
        if (!this.objectListStack.isEmpty()) {
            ObjectList item = this.objectListStack.get(this.objectListStack.size() - 1);
            if (item == ObjectList.LIST) {
                throw new JsonParseException("Incomplete list at end of document", this.documentLine, this.documentLinePos);
            }
            throw new JsonParseException("Incomplete object at end of document", this.documentLine, this.documentLinePos);
        }
        if (this.currentToken == null) {
            throw new JsonParseException("Empty document", this.documentLine, this.documentLinePos);
        }
        if (this.currentToken.getType() == JsonAtomicToken.Type.START_STRING || this.currentToken.getType() == JsonAtomicToken.Type.STRING_CHARACTER) {
            throw new JsonParseException("Incomplete string at end of document", this.documentLine, this.documentLinePos);
        }
        this.tokenStartLine = this.documentLine;
        this.tokenStartLinePos = this.documentLinePos;
        this.currentToken = null;
        return false;
    }

    private void consumeCharacter(char c) {
        --this.bufferLen;
        this.bufferPos = this.bufferLen == 0 ? 0 : ++this.bufferPos;
        if (c == '\r') {
            ++this.documentLine;
            this.documentLinePos = 1;
            this.consumedCR = true;
        } else if (c == '\n') {
            if (this.consumedCR) {
                this.consumedCR = false;
            } else {
                ++this.documentLine;
                this.documentLinePos = 1;
            }
        } else if (this.consumedCR) {
            this.consumedCR = false;
        } else {
            ++this.documentLinePos;
        }
    }

    private static enum ObjectList {
        OBJECT,
        LIST;

    }

    private static enum NumberPos {
        START,
        AFTER_MAIN_SIGN,
        AFTER_MAIN,
        IN_MAIN,
        AFTER_POINT,
        IN_FRACTION,
        AFTER_EXP,
        AFTER_EXP_SIGN,
        IN_EXP_NUMBER;

    }
}

