/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.joda.time.LocalDateTime;

public class LocalDateTimeSerializer
extends JsonSerializer<Object> {
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (!(value instanceof LocalDateTime)) {
            throw new JsonGenerationException("Can't serialize type to date/time: " + value.getClass().getName(), jgen);
        }
        LocalDateTime time = (LocalDateTime)value;
        jgen.writeString(time.toString("yyyy-MM-dd'T'HH:mm:ss.SSS"));
    }
}

