/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class MillisFromIsoDateTimeDeserializer
extends JsonDeserializer<Long> {
    public Long deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String val = (String)jp.readValueAs(String.class);
        DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
        try {
            return parser.parseMillis(val);
        }
        catch (IllegalArgumentException ex) {
            throw new JsonParseException(jp, "Invalid ISO date/time string: " + val + ": " + ex.getMessage(), jp.getTokenLocation(), (Throwable)ex);
        }
    }
}

