/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json.rpc;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.woolplatform.utils.AppComponents;
import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.json.rpc.JsonRpcException;
import eu.woolplatform.utils.json.rpc.JsonRpcMessage;
import eu.woolplatform.utils.json.rpc.JsonRpcNotification;
import eu.woolplatform.utils.json.rpc.JsonRpcRequest;
import eu.woolplatform.utils.json.rpc.JsonRpcResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class JsonRpcHttp {
    public static final String LOGTAG = "JsonRpc";
    private URL url;
    private final Object lock = new Object();
    private int nextID = 1;
    private boolean closed = false;
    private List<HttpURLConnection> connections = new ArrayList<HttpURLConnection>();

    public JsonRpcHttp(URL url) {
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            while (!this.connections.isEmpty()) {
                HttpURLConnection conn = this.connections.remove(0);
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object request(String methodName) throws IOException, JsonRpcException, ParseException {
        int id;
        Object object = this.lock;
        synchronized (object) {
            id = this.nextID++;
        }
        JsonRpcRequest request = JsonRpcRequest.create(methodName, id);
        return this.sendRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object request(String methodName, Map<String, ?> params) throws IOException, JsonRpcException, ParseException {
        int id;
        Object object = this.lock;
        synchronized (object) {
            id = this.nextID++;
        }
        JsonRpcRequest request = JsonRpcRequest.create(methodName, params, (Object)id);
        return this.sendRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object request(String methodName, Object ... params) throws IOException, JsonRpcException, ParseException {
        int id;
        Object object = this.lock;
        synchronized (object) {
            id = this.nextID++;
        }
        List<Object> list = Arrays.asList(params);
        JsonRpcRequest request = JsonRpcRequest.create(methodName, list, (Object)id);
        return this.sendRequest(request);
    }

    private Object sendRequest(JsonRpcRequest request) throws IOException, JsonRpcException, ParseException {
        Map map;
        String responseStr = this.sendMessage(request);
        Logger logger = AppComponents.getLogger(LOGTAG);
        if (logger.isTraceEnabled()) {
            logger.trace("Received message: " + responseStr);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            map = (Map)mapper.readValue(responseStr, Map.class);
        }
        catch (JsonParseException ex) {
            throw new ParseException("Can't parse JSON string: " + ex.getMessage(), ex);
        }
        catch (JsonMappingException ex) {
            throw new ParseException("Can't convert JSON string to map: " + ex.getMessage(), ex);
        }
        JsonRpcMessage recvMsg = JsonRpcMessage.read(map);
        if (!(recvMsg instanceof JsonRpcResponse)) {
            throw new ParseException("Expected JSONRPCResponse, received " + recvMsg.getClass().getName());
        }
        JsonRpcResponse response = (JsonRpcResponse)recvMsg;
        if (response.getError() != null) {
            JsonRpcResponse.Error error = response.getError();
            throw new JsonRpcException(error.getMessage(), error.getCode(), error.getData());
        }
        return response.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendMessage(JsonRpcMessage message) throws IOException {
        if (this.closed) {
            throw new IOException("JsonRpcHttp closed");
        }
        HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                conn.disconnect();
                throw new IOException("JsonRpcHttp closed");
            }
            this.connections.add(conn);
        }
        try {
            int len;
            StringBuilder buf = new StringBuilder();
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            OutputStream out = conn.getOutputStream();
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(out, "UTF-8");
                message.write(writer);
                Logger logger = AppComponents.getLogger(LOGTAG);
                if (logger.isTraceEnabled()) {
                    StringWriter strWriter = new StringWriter();
                    message.write(strWriter);
                    logger.trace("Sent message: " + strWriter.toString());
                }
            }
            finally {
                if (writer != null) {
                    ((Writer)writer).close();
                } else {
                    out.close();
                }
            }
            InputStream in = conn.getInputStream();
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            char[] cs = new char[2048];
            while ((len = reader.read(cs)) > 0) {
                buf.append(cs, 0, len);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            Object object2 = this.lock;
            synchronized (object2) {
                if (!this.closed) {
                    conn.disconnect();
                    this.connections.remove(conn);
                }
            }
        }
    }

    public void notify(String methodName) throws IOException {
        this.sendMessage(JsonRpcNotification.create(methodName));
    }

    public void notify(String methodName, Map<String, ?> params) throws IOException {
        this.sendMessage(JsonRpcNotification.create(methodName, params));
    }

    public void notify(String methodName, Object ... params) throws IOException {
        List<Object> list = Arrays.asList(params);
        this.sendMessage(JsonRpcNotification.create(methodName, list));
    }
}

