/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json.rpc;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.json.rpc.JsonRpcNotification;
import eu.woolplatform.utils.json.rpc.JsonRpcRequest;
import eu.woolplatform.utils.json.rpc.JsonRpcResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public abstract class JsonRpcMessage {
    public abstract void write(Writer var1) throws IOException;

    public static JsonRpcMessage read(Map<?, ?> map) throws ParseException {
        if (!map.containsKey("jsonrpc")) {
            throw new ParseException("Member \"jsonrpc\" not found");
        }
        if (map.containsKey("method") && map.containsKey("id")) {
            return JsonRpcRequest.read(map);
        }
        if (map.containsKey("method")) {
            return JsonRpcNotification.read(map);
        }
        if ((map.containsKey("result") || map.containsKey("error")) && map.containsKey("id")) {
            return JsonRpcResponse.read(map);
        }
        throw new ParseException("Invalid JSON-RPC message: " + map);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.write(writer);
            return writer.toString();
        }
        catch (IOException ex) {
            return super.toString();
        }
    }
}

