/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json.rpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.json.rpc.JsonRpcMessage;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonRpcNotification
extends JsonRpcMessage {
    private String method = null;
    private Map<?, ?> mapParams = null;
    private List<?> listParams = null;

    private JsonRpcNotification() {
    }

    public static JsonRpcNotification read(Map<?, ?> map) throws ParseException {
        JsonRpcNotification notification = new JsonRpcNotification();
        if (!map.containsKey("jsonrpc")) {
            throw new ParseException("Member \"jsonrpc\" not found");
        }
        Object jsonrpc = map.get("jsonrpc");
        if (!jsonrpc.equals("2.0")) {
            throw new ParseException("Value of member \"jsonrpc\" is not \"2.0\": " + jsonrpc);
        }
        if (!map.containsKey("method")) {
            throw new ParseException("Member \"method\" not found");
        }
        Object method = map.get("method");
        if (!(method instanceof String)) {
            throw new ParseException("Invalid value for member \"method\": " + method);
        }
        notification.method = (String)method;
        if (map.containsKey("params")) {
            Object params = map.get("params");
            if (params instanceof Map) {
                notification.mapParams = (Map)params;
            } else if (params instanceof List) {
                notification.listParams = (List)params;
            } else {
                throw new ParseException("Invalid value for member \"params\": " + params);
            }
        }
        return notification;
    }

    public static JsonRpcNotification create(String method) {
        return JsonRpcNotification.create(method, null, null);
    }

    public static JsonRpcNotification create(String method, Map<String, ?> params) {
        return JsonRpcNotification.create(method, params, null);
    }

    public static JsonRpcNotification create(String method, List<?> params) {
        return JsonRpcNotification.create(method, null, params);
    }

    private static JsonRpcNotification create(String method, Map<String, ?> mapParams, List<?> listParams) {
        JsonRpcNotification notification = new JsonRpcNotification();
        if (method == null) {
            throw new NullPointerException("Method is null");
        }
        notification.method = method;
        notification.mapParams = mapParams;
        notification.listParams = listParams;
        return notification;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<?, ?> getMapParams() {
        return this.mapParams;
    }

    public List<?> getListParams() {
        return this.listParams;
    }

    @Override
    public void write(Writer out) throws IOException {
        String json = this.toString();
        out.write(json);
        out.flush();
    }

    @Override
    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jsonrpc", "2.0");
        map.put("method", this.method);
        if (this.mapParams != null) {
            map.put("params", this.mapParams);
        } else if (this.listParams != null) {
            map.put("params", this.listParams);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Can't write JSON string: " + ex.getMessage(), ex);
        }
    }
}

