/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json.rpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.json.rpc.JsonRpcMessage;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonRpcRequest
extends JsonRpcMessage {
    private String method = null;
    private Map<?, ?> mapParams = null;
    private List<?> listParams = null;
    private Object id = null;

    private JsonRpcRequest() {
    }

    public static JsonRpcRequest read(Map<?, ?> map) throws ParseException {
        JsonRpcRequest request = new JsonRpcRequest();
        if (!map.containsKey("jsonrpc")) {
            throw new ParseException("Member \"jsonrpc\" not found");
        }
        Object jsonrpc = map.get("jsonrpc");
        if (!jsonrpc.equals("2.0")) {
            throw new ParseException("Value of member \"jsonrpc\" is not \"2.0\": " + jsonrpc);
        }
        if (!map.containsKey("method")) {
            throw new ParseException("Member \"method\" not found");
        }
        Object method = map.get("method");
        if (!(method instanceof String)) {
            throw new ParseException("Invalid value for member \"method\": " + method);
        }
        request.method = (String)method;
        if (map.containsKey("params")) {
            Object params = map.get("params");
            if (params instanceof Map) {
                request.mapParams = (Map)params;
            } else if (params instanceof List) {
                request.listParams = (List)params;
            } else {
                throw new ParseException("Invalid value for member \"params\": " + params);
            }
        }
        if (!map.containsKey("id")) {
            throw new ParseException("Member \"id\" not found");
        }
        request.id = map.get("id");
        if (request.id != null && !(request.id instanceof Number) && !(request.id instanceof String)) {
            throw new ParseException("Invalid value for member \"id\": " + request.id);
        }
        return request;
    }

    public static JsonRpcRequest create(String method, Object id) {
        return JsonRpcRequest.create(method, null, null, id);
    }

    public static JsonRpcRequest create(String method, Map<String, ?> params, Object id) {
        return JsonRpcRequest.create(method, params, null, id);
    }

    public static JsonRpcRequest create(String method, List<?> params, Object id) {
        return JsonRpcRequest.create(method, null, params, id);
    }

    private static JsonRpcRequest create(String method, Map<String, ?> mapParams, List<?> listParams, Object id) {
        JsonRpcRequest request = new JsonRpcRequest();
        if (method == null) {
            throw new NullPointerException("Method is null");
        }
        request.method = method;
        request.mapParams = mapParams;
        request.listParams = listParams;
        if (id != null && !(id instanceof Number) && !(id instanceof String)) {
            throw new IllegalArgumentException("Invalid ID: " + id);
        }
        request.id = id;
        return request;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<?, ?> getMapParams() {
        return this.mapParams;
    }

    public List<?> getListParams() {
        return this.listParams;
    }

    public Object getID() {
        return this.id;
    }

    @Override
    public void write(Writer out) throws IOException {
        String json = this.toString();
        out.write(json);
        out.flush();
    }

    @Override
    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jsonrpc", "2.0");
        map.put("method", this.method);
        if (this.mapParams != null) {
            map.put("params", this.mapParams);
        } else if (this.listParams != null) {
            map.put("params", this.listParams);
        }
        map.put("id", this.id);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Can't write JSON string: " + ex.getMessage(), ex);
        }
    }
}

