/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.json.rpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.json.rpc.JsonRpcMessage;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonRpcResponse
extends JsonRpcMessage {
    private Object result = null;
    private Error error = null;
    private Object id = null;

    private JsonRpcResponse() {
    }

    public static JsonRpcResponse read(Map<?, ?> map) throws ParseException {
        JsonRpcResponse response = new JsonRpcResponse();
        if (!map.containsKey("jsonrpc")) {
            throw new ParseException("Member \"jsonrpc\" not found");
        }
        Object jsonrpc = map.get("jsonrpc");
        if (!jsonrpc.equals("2.0")) {
            throw new ParseException("Value of member \"jsonrpc\" is not \"2.0\": " + jsonrpc);
        }
        if (!map.containsKey("result") && !map.containsKey("error")) {
            throw new ParseException("Member \"result\" or \"error\" not found");
        }
        if (map.containsKey("result") && map.containsKey("error")) {
            throw new ParseException("Found both member \"result\" and \"error\"");
        }
        if (map.containsKey("result")) {
            response.result = map.get("result");
        }
        if (map.containsKey("error")) {
            Object error = map.get("error");
            if (!(error instanceof Map)) {
                throw new ParseException("Invalid value for member \"error\": " + error);
            }
            response.error = Error.read((Map)error);
        }
        if (!map.containsKey("id")) {
            throw new ParseException("Member \"id\" not found");
        }
        response.id = map.get("id");
        if (response.id != null && !(response.id instanceof Number) && !(response.id instanceof String)) {
            throw new ParseException("Invalid value for member \"id\": " + response.id);
        }
        return response;
    }

    public static JsonRpcResponse createResult(Object result, Object id) {
        return JsonRpcResponse.create(result, null, id);
    }

    public static JsonRpcResponse createError(Error error, Object id) {
        return JsonRpcResponse.create(null, error, id);
    }

    private static JsonRpcResponse create(Object result, Error error, Object id) {
        JsonRpcResponse response = new JsonRpcResponse();
        if (result == null && error == null) {
            throw new IllegalArgumentException("Result or error must be specified");
        }
        if (result != null && error != null) {
            throw new IllegalArgumentException("Both result and error specified");
        }
        response.result = result;
        response.error = error;
        if (id != null && !(id instanceof Number) && !(id instanceof String)) {
            throw new IllegalArgumentException("Invalid ID: " + id);
        }
        response.id = id;
        return response;
    }

    public Object getResult() {
        return this.result;
    }

    public Error getError() {
        return this.error;
    }

    public Object getID() {
        return this.id;
    }

    @Override
    public void write(Writer out) throws IOException {
        String json = this.toString();
        out.write(json);
        out.flush();
    }

    @Override
    public String toString() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("jsonrpc", "2.0");
        if (this.result != null) {
            map.put("result", this.result);
        } else if (this.error != null) {
            map.put("error", this.error.write());
        }
        map.put("id", this.id);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Can't write JSON string: " + ex.getMessage(), ex);
        }
    }

    public static class Error {
        private int code = 0;
        private String message = null;
        private Object data = null;

        private Error() {
        }

        public static Error read(Map<?, ?> map) throws ParseException {
            Error error = new Error();
            if (!map.containsKey("code")) {
                throw new ParseException("Member \"code\" not found");
            }
            Object code = map.get("code");
            if (!(code instanceof Number)) {
                throw new ParseException("Invalid value for member \"code\": " + code);
            }
            error.code = ((Number)code).intValue();
            if (!map.containsKey("message")) {
                throw new ParseException("Member \"message\" not found");
            }
            Object message = map.get("message");
            if (!(message instanceof String)) {
                throw new ParseException("Invalid value for member \"message\": " + message);
            }
            error.message = (String)message;
            error.data = map.get("data");
            return error;
        }

        public static Error create(int code, String message) {
            return Error.create(code, message, null);
        }

        public static Error create(int code, String message, Object data) {
            Error error = new Error();
            error.code = code;
            error.message = message;
            error.data = data;
            return error;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getData() {
            return this.data;
        }

        private Map<?, ?> write() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("code", this.code);
            map.put("message", this.message);
            if (this.data != null) {
                map.put("data", this.data);
            }
            return map;
        }
    }
}

