/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.log;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.log.FileLogger;
import eu.woolplatform.utils.log.LogDelegate;
import eu.woolplatform.utils.log.LogLineTagger;
import eu.woolplatform.utils.schedule.Job;
import eu.woolplatform.utils.schedule.SerialJobRunner;
import eu.woolplatform.utils.xml.SimpleSAXHandler;
import eu.woolplatform.utils.xml.SimpleSAXParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public abstract class AbstractLogDelegate
implements LogDelegate {
    public static int ERROR_WRITE_FILE = 1;
    protected static int ERROR_BASE = 65536;
    private int defaultLevel = 4;
    private Map<String, Integer> levelMap = new HashMap<String, Integer>();
    private static PrintStream oldStdOut = null;
    private static PrintStream oldStdErr = null;
    private FileLogger fileLogger = null;
    private SerialJobRunner fileLogRunner = new SerialJobRunner();
    private final Object lock = new Object();

    public AbstractLogDelegate() {
        if (oldStdOut == null) {
            oldStdOut = System.out;
        }
        if (oldStdErr == null) {
            oldStdErr = System.err;
        }
    }

    public void setLogLevels(File xmlFile) throws ParseException, IOException {
        try (FileInputStream in = new FileInputStream(xmlFile);){
            this.setLogLevels(in);
        }
    }

    public void setLogLevels(InputStream in) throws ParseException, IOException {
        SimpleSAXParser<LogLevelMap> parser = new SimpleSAXParser<LogLevelMap>(new XMLHandler());
        LogLevelMap map = parser.parse(new InputSource(in));
        this.defaultLevel = map.defaultLevel;
        this.levelMap = map.levelMap;
    }

    public void setLogLevel(int level) {
        this.defaultLevel = level;
    }

    public void setLogLevel(String tag, int level) {
        this.levelMap.put(tag, level);
    }

    public void setCaptureStdOut(boolean capture) {
        if (capture) {
            System.setOut(new PrintStream(new LogStream(true)));
        } else {
            System.setOut(oldStdOut);
        }
    }

    public void setCaptureStdErr(boolean capture) {
        if (capture) {
            System.setErr(new PrintStream(new LogStream(false)));
        } else {
            System.setErr(oldStdErr);
        }
    }

    public void setFileLogger(FileLogger fileLogger) {
        this.fileLogger = fileLogger;
    }

    public FileLogger getFileLogger() {
        return this.fileLogger;
    }

    protected PrintStream getDefaultStdOut() {
        return oldStdOut;
    }

    protected PrintStream getDefaultStdErr() {
        return oldStdErr;
    }

    private int println(int priority, String tag, String msg, Throwable tr) {
        if (!this.isLoggable(tag, priority)) {
            return 0;
        }
        String newline = System.getProperty("line.separator");
        String errMsg = msg;
        if (tr != null) {
            errMsg = errMsg + newline + this.getStackTraceString(tr);
        }
        return this.println(priority, tag, errMsg);
    }

    private int println(int priority, String tag, Throwable tr) {
        if (!this.isLoggable(tag, priority)) {
            return 0;
        }
        String errMsg = tr != null ? this.getStackTraceString(tr) : "null";
        return this.println(priority, tag, errMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int println(int priority, String tag, String msg) {
        if (!this.isLoggable(tag, priority)) {
            return 0;
        }
        DateTime time = new DateTime();
        String taggedMsg = LogLineTagger.tagLines(priority, tag, time, msg);
        Object object = this.lock;
        synchronized (object) {
            int result = this.printTaggedMessage(priority, tag, taggedMsg);
            if (this.fileLogger != null) {
                this.fileLogRunner.postJob(new FileLogJob(priority, tag, time.toLocalDate(), taggedMsg), null);
            }
            return result;
        }
    }

    public abstract int printTaggedMessage(int var1, String var2, String var3);

    @Override
    public String getStackTraceString(Throwable tr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        return sw.toString();
    }

    @Override
    public boolean isLoggable(String tag, int level) {
        if (level < 2 || level > 7) {
            return false;
        }
        Integer tagLevel = this.levelMap.get(tag);
        if (tagLevel == null) {
            return level >= this.defaultLevel;
        }
        return level >= tagLevel;
    }

    @Override
    public int d(String tag, String msg, Throwable tr) {
        return this.println(3, tag, msg, tr);
    }

    @Override
    public int d(String tag, String msg) {
        return this.println(3, tag, msg);
    }

    @Override
    public int e(String tag, String msg) {
        return this.println(6, tag, msg);
    }

    @Override
    public int e(String tag, String msg, Throwable tr) {
        return this.println(6, tag, msg, tr);
    }

    @Override
    public int i(String tag, String msg, Throwable tr) {
        return this.println(4, tag, msg, tr);
    }

    @Override
    public int i(String tag, String msg) {
        return this.println(4, tag, msg);
    }

    @Override
    public int v(String tag, String msg, Throwable tr) {
        return this.println(2, tag, msg, tr);
    }

    @Override
    public int v(String tag, String msg) {
        return this.println(2, tag, msg);
    }

    @Override
    public int w(String tag, String msg) {
        return this.println(5, tag, msg);
    }

    @Override
    public int w(String tag, Throwable tr) {
        return this.println(5, tag, tr);
    }

    @Override
    public int w(String tag, String msg, Throwable tr) {
        return this.println(5, tag, msg, tr);
    }

    @Override
    public int wtf(String tag, String msg) {
        return this.println(7, tag, msg);
    }

    @Override
    public int wtf(String tag, Throwable tr) {
        return this.println(7, tag, tr);
    }

    @Override
    public int wtf(String tag, String msg, Throwable tr) {
        return this.println(7, tag, msg, tr);
    }

    private class LogStream
    extends OutputStream {
        private Charset charset;
        private boolean isStdOut;
        private ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        private boolean lastIsCR = false;

        public LogStream(boolean isStdOut) {
            this.charset = Charset.defaultCharset();
            this.isStdOut = isStdOut;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)});
        }

        @Override
        public void write(byte[] bs) throws IOException {
            this.write(bs, 0, bs.length);
        }

        @Override
        public void write(byte[] bs, int off, int len) throws IOException {
            int start = off;
            for (int i = off; i < off + len; ++i) {
                byte b = bs[i];
                if (b == 13) {
                    this.byteOut.write(bs, start, i - start);
                    this.writeBufferedLine();
                    start = i + 1;
                    this.lastIsCR = true;
                    continue;
                }
                if (b == 10) {
                    if (!this.lastIsCR) {
                        this.byteOut.write(bs, start, i - start);
                        this.writeBufferedLine();
                    }
                    start = i + 1;
                    this.lastIsCR = false;
                    continue;
                }
                this.lastIsCR = false;
            }
            if (start < off + len) {
                this.byteOut.write(bs, start, off + len - start);
            }
        }

        private void writeBufferedLine() {
            ByteBuffer bb = ByteBuffer.wrap(this.byteOut.toByteArray());
            this.byteOut.reset();
            CharBuffer cs = this.charset.decode(bb);
            if (this.isStdOut) {
                AbstractLogDelegate.this.i("STDOUT", cs.toString());
            } else {
                AbstractLogDelegate.this.e("STDERR", cs.toString());
            }
        }
    }

    private class LogLevelMap {
        public int defaultLevel = 4;
        public Map<String, Integer> levelMap = new HashMap<String, Integer>();

        private LogLevelMap() {
        }
    }

    private class XMLHandler
    implements SimpleSAXHandler<LogLevelMap> {
        private LogLevelMap map;

        private XMLHandler() {
            this.map = new LogLevelMap();
        }

        @Override
        public void startElement(String name, Attributes atts, List<String> parents) throws ParseException {
            if (name.equals("loglevels")) {
                this.startLoglevels(atts);
            } else if (name.equals("tag")) {
                this.startTag(atts);
            }
        }

        private void startLoglevels(Attributes atts) throws ParseException {
            String s = atts.getValue("level");
            if (s != null) {
                this.map.defaultLevel = this.parseLevel(s);
            }
        }

        private void startTag(Attributes atts) throws ParseException {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ParseException("Attribute \"name\" not found");
            }
            if (this.map.levelMap.containsKey(name)) {
                throw new ParseException("Duplicate tag name: " + name);
            }
            String s = atts.getValue("level");
            if (s == null) {
                throw new ParseException("Attribute \"level\" not found");
            }
            int level = this.parseLevel(s);
            this.map.levelMap.put(name, level);
        }

        private int parseLevel(String s) throws ParseException {
            switch (s) {
                case "ASSERT": {
                    return 7;
                }
                case "ERROR": {
                    return 6;
                }
                case "WARN": {
                    return 5;
                }
                case "INFO": {
                    return 4;
                }
                case "DEBUG": {
                    return 3;
                }
                case "VERBOSE": {
                    return 2;
                }
            }
            throw new ParseException("Invalid log level: " + s);
        }

        @Override
        public void endElement(String name, List<String> parents) throws ParseException {
        }

        @Override
        public void characters(String ch, List<String> parents) throws ParseException {
        }

        @Override
        public LogLevelMap getObject() {
            return this.map;
        }
    }

    private class FileLogJob
    implements Job {
        private int priority;
        private String tag;
        private LocalDate date;
        private String taggedMsg;

        public FileLogJob(int priority, String tag, LocalDate date, String taggedMsg) {
            this.priority = priority;
            this.tag = tag;
            this.date = date;
            this.taggedMsg = taggedMsg;
        }

        @Override
        public void run() {
            AbstractLogDelegate.this.fileLogger.printTaggedMessage(this.priority, this.tag, this.date, this.taggedMsg);
        }

        @Override
        public void cancel() {
        }
    }
}

