/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.log;

import eu.woolplatform.utils.io.FileUtils;
import eu.woolplatform.utils.io.ZipUtils;
import eu.woolplatform.utils.log.AbstractLogDelegate;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class FileLogger {
    public static final Object ARCHIVE_LOCK = new Object();
    private File logDir;
    private final Object lock = new Object();
    private int archiveDelay = 0;
    private int purgeDelay = 0;
    private LocalDate archivedUntil = null;
    private LocalDate purgedUntil = null;

    public FileLogger(File logDir) throws IOException {
        this.logDir = logDir;
        FileUtils.mkdir(logDir);
        String[] zipFiles = logDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.matches("[0-9]{8}\\.zip");
            }
        });
        if (zipFiles.length > 0) {
            ArrayList<String> zipFileList = new ArrayList<String>(Arrays.asList(zipFiles));
            Collections.sort(zipFileList);
            String lastFile = (String)zipFileList.get(zipFileList.size() - 1);
            DateTimeFormatter parser = DateTimeFormat.forPattern((String)"yyyyMMdd");
            this.archivedUntil = parser.parseLocalDate(lastFile.substring(0, 8));
        }
    }

    public void setArchiveDelay(int days) {
        this.archiveDelay = days;
    }

    public void setPurgeDelay(int days) {
        this.purgeDelay = days;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int printTaggedMessage(int priority, String tag, LocalDate date, String msg) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Writer out = this.openLogFile(date);
                if (out == null) {
                    return 0;
                }
                try {
                    out.write(msg);
                }
                finally {
                    out.close();
                }
                return 0;
            }
            catch (IOException ex) {
                return AbstractLogDelegate.ERROR_WRITE_FILE;
            }
        }
    }

    private Writer openLogFile(LocalDate date) throws IOException {
        this.purgeFiles(date);
        this.archiveFiles(date);
        if (this.archivedUntil != null && !this.archivedUntil.isBefore((ReadablePartial)date) || this.purgedUntil != null && !this.purgedUntil.isBefore((ReadablePartial)date)) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
        String filename = formatter.print((ReadablePartial)date) + ".log";
        File file = new File(this.logDir, filename);
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeFiles(LocalDate date) {
        if (this.purgeDelay <= 0) {
            return;
        }
        LocalDate minDate = null;
        if (this.purgedUntil != null) {
            minDate = this.purgedUntil.plusDays(1);
        }
        LocalDate maxDate = date.minusDays(this.purgeDelay);
        if (minDate != null && minDate.isAfter((ReadablePartial)maxDate)) {
            return;
        }
        this.purgedUntil = maxDate;
        Object object = ARCHIVE_LOCK;
        synchronized (object) {
            File[] files;
            for (File file : files = this.logDir.listFiles(new PurgeFilter(maxDate))) {
                if (file.delete()) continue;
                System.err.println("Can't purge log file: " + file.getAbsolutePath());
            }
        }
    }

    private void archiveFiles(LocalDate date) {
        if (this.archiveDelay <= 0) {
            return;
        }
        LocalDate minDate = null;
        if (this.archivedUntil != null) {
            minDate = this.archivedUntil.plusDays(1);
        }
        LocalDate maxDate = date.minusDays(this.archiveDelay);
        if (minDate != null && minDate.isAfter((ReadablePartial)maxDate)) {
            return;
        }
        this.archivedUntil = maxDate;
        new ArchiveFilesThread(minDate, maxDate).start();
    }

    private class PurgeFilter
    implements FileFilter {
        private LocalDate maxDate;

        public PurgeFilter(LocalDate maxDate) {
            this.maxDate = maxDate;
        }

        @Override
        public boolean accept(File pathname) {
            LocalDate fileDate;
            if (FileLogger.this.purgeDelay <= 0) {
                return false;
            }
            if (!pathname.isFile()) {
                return false;
            }
            String filename = pathname.getName();
            if (!filename.matches("[0-9]{8}\\..*")) {
                return false;
            }
            String dateStr = filename.substring(0, 8);
            DateTimeFormatter parser = DateTimeFormat.forPattern((String)"yyyyMMdd");
            try {
                fileDate = parser.parseLocalDate(dateStr);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
            return !fileDate.isAfter((ReadablePartial)this.maxDate);
        }
    }

    private class ArchiveFilter
    implements FileFilter {
        private LocalDate minDate;
        private LocalDate maxDate;

        public ArchiveFilter(LocalDate minDate, LocalDate maxDate) {
            this.minDate = minDate;
            this.maxDate = maxDate;
        }

        @Override
        public boolean accept(File pathname) {
            LocalDate fileDate;
            if (FileLogger.this.archiveDelay <= 0) {
                return false;
            }
            if (!pathname.isFile()) {
                return false;
            }
            String filename = pathname.getName();
            if (!filename.matches("[0-9]{8}\\.log")) {
                return false;
            }
            String dateStr = filename.substring(0, 8);
            DateTimeFormatter parser = DateTimeFormat.forPattern((String)"yyyyMMdd");
            try {
                fileDate = parser.parseLocalDate(dateStr);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
            if (this.minDate != null && fileDate.isBefore((ReadablePartial)this.minDate)) {
                return false;
            }
            return !fileDate.isAfter((ReadablePartial)this.maxDate);
        }
    }

    private class ArchiveFilesThread
    extends Thread {
        private LocalDate minDate;
        private LocalDate maxDate;

        public ArchiveFilesThread(LocalDate minDate, LocalDate maxDate) {
            this.minDate = minDate;
            this.maxDate = maxDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File[] files = FileLogger.this.logDir.listFiles(new ArchiveFilter(this.minDate, this.maxDate));
            if (files.length == 0) {
                return;
            }
            ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(files));
            Collections.sort(fileList);
            for (File file : fileList) {
                String dateStr = file.getName().substring(0, 8);
                Object object = ARCHIVE_LOCK;
                synchronized (object) {
                    File zipFile = new File(FileLogger.this.logDir, dateStr + ".zip");
                    try {
                        ZipUtils.zipFile(file, zipFile);
                    }
                    catch (IOException ex) {
                        System.err.println("Can't archive log file \"" + file.getAbsolutePath() + "\": " + ex.getMessage());
                        ex.printStackTrace();
                        return;
                    }
                    if (!file.delete()) {
                        System.err.println("Can't delete archived log file: " + file.getAbsolutePath());
                        return;
                    }
                }
            }
        }
    }
}

