/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.log;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class LogLineTagger {
    public static String tagLines(int level, String tag, DateTime time, String msg) {
        String newline = System.getProperty("line.separator");
        DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
        String timeStr = formatter.print((ReadableInstant)time);
        String[] lines = msg.split("\r\n|\r|\n", -1);
        StringBuffer buf = new StringBuffer();
        for (String line : lines) {
            buf.append("[");
            buf.append(LogLineTagger.levelToString(level));
            buf.append("] [");
            buf.append(tag);
            buf.append("] [");
            buf.append(timeStr);
            buf.append("] ");
            buf.append(line);
            buf.append(newline);
        }
        return buf.toString();
    }

    private static String levelToString(int level) {
        switch (level) {
            case 7: {
                return "ASSERT";
            }
            case 6: {
                return "ERROR";
            }
            case 5: {
                return "WARN";
            }
            case 4: {
                return "INFO";
            }
            case 3: {
                return "DEBUG";
            }
            case 2: {
                return "VERBOSE";
            }
        }
        return "UNKNOWN";
    }
}

