/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.log;

import eu.woolplatform.utils.log.Logger;
import org.slf4j.Marker;

public class Slf4jLogger
implements org.slf4j.Logger {
    private String name;

    public Slf4jLogger(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return Logger.isLoggable(this.name, 2);
    }

    public void trace(String msg) {
        Logger.v(this.name, msg);
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            Logger.v(this.name, this.formatString(format, arg));
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            Logger.v(this.name, this.formatString(format, arg1, arg2));
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            Logger.v(this.name, this.formatString(format, arguments));
        }
    }

    public void trace(String msg, Throwable t) {
        Logger.v(this.name, msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.trace(format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    public boolean isDebugEnabled() {
        return Logger.isLoggable(this.name, 3);
    }

    public void debug(String msg) {
        Logger.d(this.name, msg);
    }

    public void debug(String format, Object arg) {
        Logger.d(this.name, this.formatString(format, arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        Logger.d(this.name, this.formatString(format, arg1, arg2));
    }

    public void debug(String format, Object ... arguments) {
        Logger.d(this.name, this.formatString(format, arguments));
    }

    public void debug(String msg, Throwable t) {
        Logger.d(this.name, msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    public boolean isInfoEnabled() {
        return Logger.isLoggable(this.name, 4);
    }

    public void info(String msg) {
        Logger.i(this.name, msg);
    }

    public void info(String format, Object arg) {
        Logger.i(this.name, this.formatString(format, arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        Logger.i(this.name, this.formatString(format, arg1, arg2));
    }

    public void info(String format, Object ... arguments) {
        Logger.i(this.name, this.formatString(format, arguments));
    }

    public void info(String msg, Throwable t) {
        Logger.i(this.name, msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    public boolean isWarnEnabled() {
        return Logger.isLoggable(this.name, 5);
    }

    public void warn(String msg) {
        Logger.w(this.name, msg);
    }

    public void warn(String format, Object arg) {
        Logger.w(this.name, this.formatString(format, arg));
    }

    public void warn(String format, Object arg1, Object arg2) {
        Logger.w(this.name, this.formatString(format, arg1, arg2));
    }

    public void warn(String format, Object ... arguments) {
        Logger.w(this.name, this.formatString(format, arguments));
    }

    public void warn(String msg, Throwable t) {
        Logger.w(this.name, msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return Logger.isLoggable(this.name, 6);
    }

    public void error(String msg) {
        Logger.e(this.name, msg);
    }

    public void error(String format, Object arg) {
        Logger.e(this.name, this.formatString(format, arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        Logger.e(this.name, this.formatString(format, arg1, arg2));
    }

    public void error(String format, Object ... arguments) {
        Logger.e(this.name, this.formatString(format, arguments));
    }

    public void error(String msg, Throwable t) {
        Logger.e(this.name, msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }

    private String formatString(String format, Object arg) {
        int index = format.indexOf("{}");
        if (index == -1) {
            return format;
        }
        return format.substring(0, index) + (arg == null ? "null" : arg.toString()) + format.substring(index + 2);
    }

    private String formatString(String format, Object arg1, Object arg2) {
        StringBuilder builder = new StringBuilder();
        int index = format.indexOf("{}");
        if (index == -1) {
            return format;
        }
        builder.append(format.substring(0, index));
        builder.append(arg1 == null ? "null" : arg1.toString());
        int start = index + 2;
        index = format.indexOf("{}", start);
        if (index == -1) {
            builder.append(format.substring(start));
            return builder.toString();
        }
        builder.append(format.substring(start, index));
        builder.append(arg2 == null ? "null" : arg2.toString());
        builder.append(format.substring(index + 2));
        return builder.toString();
    }

    private String formatString(String format, Object ... arguments) {
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (Object arg : arguments) {
            int index = format.indexOf("{}", start);
            if (index == -1) break;
            builder.append(format.substring(start, index));
            builder.append(arg == null ? "null" : arg.toString());
            start = index + 2;
        }
        builder.append(format.substring(start));
        return builder.toString();
    }
}

