/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LinearFunction {
    private List<Point> points = new ArrayList<Point>();

    public void addPoint(float x, float y) {
        int i = 0;
        while (i < this.points.size()) {
            Point cmp = this.points.get(i);
            if (x < cmp.x) {
                this.points.add(i, new Point(x, y));
                continue;
            }
            ++i;
        }
        this.points.add(new Point(x, y));
    }

    public float get(float x) {
        Iterator<Point> it = this.points.iterator();
        if (!it.hasNext()) {
            return 0.0f;
        }
        Point p1 = it.next();
        if (!it.hasNext()) {
            return p1.y;
        }
        Point p2 = it.next();
        while (x > p2.x && it.hasNext()) {
            p1 = p2;
            p2 = it.next();
        }
        float prop = (x - p1.x) / (p2.x - p1.x);
        return p1.y + prop * (p2.y - p1.y);
    }

    private class Point {
        public float x;
        public float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

