/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.schedule;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.schedule.DateUnit;
import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Years;

public class DateDuration {
    private int count;
    private DateUnit unit;

    public DateDuration(int count, DateUnit unit) {
        this.count = count;
        this.unit = unit;
    }

    public int getCount() {
        return this.count;
    }

    public DateUnit getUnit() {
        return this.unit;
    }

    public int getCountBetween(ReadableInstant start, ReadableInstant end) {
        int singleCount = this.unit == DateUnit.DAY ? Days.daysBetween((ReadableInstant)start, (ReadableInstant)end).getDays() : (this.unit == DateUnit.WEEK ? Days.daysBetween((ReadableInstant)start, (ReadableInstant)end).getDays() / 7 : (this.unit == DateUnit.MONTH ? Months.monthsBetween((ReadableInstant)start, (ReadableInstant)end).getMonths() : Years.yearsBetween((ReadableInstant)start, (ReadableInstant)end).getYears()));
        return singleCount / this.count;
    }

    public int getCountBetween(ReadablePartial start, ReadablePartial end) {
        int singleCount = this.unit == DateUnit.DAY ? Days.daysBetween((ReadablePartial)start, (ReadablePartial)end).getDays() : (this.unit == DateUnit.WEEK ? Days.daysBetween((ReadablePartial)start, (ReadablePartial)end).getDays() / 7 : (this.unit == DateUnit.MONTH ? Months.monthsBetween((ReadablePartial)start, (ReadablePartial)end).getMonths() : Years.yearsBetween((ReadablePartial)start, (ReadablePartial)end).getYears()));
        return singleCount / this.count;
    }

    public ReadablePeriod toReadablePeriod() {
        if (this.unit == DateUnit.DAY) {
            return Days.days((int)this.count);
        }
        if (this.unit == DateUnit.WEEK) {
            return Days.days((int)(this.count * 7));
        }
        if (this.unit == DateUnit.MONTH) {
            return Months.months((int)this.count);
        }
        return Years.years((int)this.count);
    }

    public int hashCode() {
        return this.count;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateDuration)) {
            return false;
        }
        DateDuration cmp = (DateDuration)obj;
        if (this.count != cmp.count) {
            return false;
        }
        return this.unit == cmp.unit;
    }

    public String toString() {
        return this.unit.getDurationString(this.count);
    }

    public static DateDuration parse(String s, DateUnit min, DateUnit max) throws ParseException {
        DateUnit unit;
        int count;
        String trimmed = s.trim();
        if (trimmed.length() == 0) {
            throw new ParseException("Invalid date duration: " + s);
        }
        String[] split = trimmed.split("\\s+");
        if (split.length != 2) {
            throw new ParseException("Invalid date duration: " + s);
        }
        try {
            count = Integer.parseInt(split[0]);
            unit = DateUnit.parse(split[1], min, max);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Invalid date duration: " + s, ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("Invalid date duration: " + s, ex);
        }
        if (count <= 0) {
            throw new ParseException("Invalid date duration: " + s);
        }
        return new DateDuration(count, unit);
    }
}

