/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.schedule;

import java.util.ArrayList;
import java.util.List;

public class DateUnit {
    public static final DateUnit YEAR = new DateUnit("year", "years");
    public static final DateUnit MONTH = new DateUnit("month", "months");
    public static final DateUnit WEEK = new DateUnit("week", "weeks");
    public static final DateUnit DAY = new DateUnit("day", "days");
    private static Object lock = new Object();
    private static List<DateUnit> dateUnits = null;
    private String singular;
    private String plural;

    private DateUnit(String singular, String plural) {
        this.singular = singular;
        this.plural = plural;
    }

    public String getDurationString(int n) {
        if (n == 1) {
            return n + " " + this.singular;
        }
        return n + " " + this.plural;
    }

    public static DateUnit parse(String s, DateUnit min, DateUnit max) throws IllegalArgumentException {
        DateUnit[] units;
        String lower = s.toLowerCase();
        for (DateUnit du : units = DateUnit.getDateUnits(min, max)) {
            if (!lower.equals(du.singular) && !lower.equals(du.plural)) continue;
            return du;
        }
        throw new IllegalArgumentException("Invalid date unit: " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateUnit[] getDateUnits(DateUnit min, DateUnit max) {
        Object object = lock;
        synchronized (object) {
            if (dateUnits == null) {
                dateUnits = new ArrayList<DateUnit>();
                dateUnits.add(DAY);
                dateUnits.add(WEEK);
                dateUnits.add(MONTH);
                dateUnits.add(YEAR);
            }
        }
        if (min == null) {
            min = DAY;
        }
        if (max == null) {
            max = YEAR;
        }
        int minIndex = dateUnits.indexOf(min);
        int maxIndex = dateUnits.indexOf(max);
        DateUnit[] result = new DateUnit[maxIndex - minIndex + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = dateUnits.get(i + minIndex);
        }
        return result;
    }

    public String toString() {
        return this.singular;
    }
}

