/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.schedule;

import eu.woolplatform.utils.datetime.DateTimeUtils;
import eu.woolplatform.utils.schedule.ScheduleParams;
import eu.woolplatform.utils.schedule.ScheduledTaskSpec;
import eu.woolplatform.utils.schedule.TaskScheduler;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DefaultTaskScheduler
extends TaskScheduler {
    private final Object lock = new Object();
    private Map<String, Timer> timerMap = new HashMap<String, Timer>();
    private Map<String, ScheduledTaskSpec> taskMap = new HashMap<String, ScheduledTaskSpec>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scheduleTask(Object context, ScheduledTaskSpec taskSpec) {
        Object object = this.lock;
        synchronized (object) {
            Timer timer = new Timer();
            final String taskId = taskSpec.getId();
            this.timerMap.put(taskId, timer);
            this.taskMap.put(taskId, taskSpec);
            ScheduleParams scheduleParams = taskSpec.getScheduleParams();
            DateTime time = scheduleParams.getLocalTime() != null ? DateTimeUtils.localToUtcWithGapCorrection(scheduleParams.getLocalTime(), DateTimeZone.getDefault()) : new DateTime((Object)scheduleParams.getUtcTime());
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    DefaultTaskScheduler.this.runTask(taskId);
                }
            }, time.toDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(String taskId) {
        ScheduledTaskSpec taskSpec;
        Object object = this.lock;
        synchronized (object) {
            this.timerMap.remove(taskId);
            taskSpec = this.taskMap.remove(taskId);
        }
        if (taskSpec == null) {
            return;
        }
        this.onTriggerTask(null, taskSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancelScheduledTask(Object context, String taskId) {
        Object object = this.lock;
        synchronized (object) {
            this.taskMap.remove(taskId);
            Timer timer = this.timerMap.remove(taskId);
            if (timer != null) {
                timer.cancel();
            }
        }
    }

    @Override
    protected void runOnUiThread(Runnable runnable) {
        runnable.run();
    }

    @Override
    protected boolean canRunTaskOnMainThread() {
        return false;
    }
}

