/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.schedule;

import eu.woolplatform.utils.AppComponents;
import eu.woolplatform.utils.schedule.Job;
import eu.woolplatform.utils.schedule.JobListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;

public class SerialJobRunner {
    public static final int PRIORITY_NONE = 0;
    public static final int PRIORITY_LOW = 100;
    public static final int PRIORITY_MEDIUM = 200;
    public static final int PRIORITY_HIGH = 300;
    private final Object lock = new Object();
    private final String logtag;
    private Thread thread = null;
    private List<JobDetails> pendingJobs = new ArrayList<JobDetails>();
    private JobDetails currentJob = null;

    public SerialJobRunner() {
        this.logtag = this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Job> getJobs() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Job> result = new ArrayList<Job>();
            if (this.currentJob != null) {
                result.add(this.currentJob.job);
            }
            for (JobDetails job : this.pendingJobs) {
                result.add(job.job);
            }
            return result;
        }
    }

    public void postJob(Job job, JobListener listener) {
        this.postJob(job, 200, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postJob(Job job, int priority, JobListener listener) {
        Object object = this.lock;
        synchronized (object) {
            Integer index = null;
            for (int i = this.pendingJobs.size() - 1; index == null && i >= 0; --i) {
                JobDetails other = this.pendingJobs.get(i);
                if (other.priority < priority) continue;
                index = i + 1;
            }
            if (index == null) {
                index = 0;
            }
            this.pendingJobs.add(index, new JobDetails(job, priority, listener));
            if (this.thread == null) {
                this.thread = new Thread(){

                    @Override
                    public void run() {
                        SerialJobRunner.this.runThread();
                    }
                };
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobs() {
        Object object = this.lock;
        synchronized (object) {
            final ArrayList<JobDetails> cancelledJobs = new ArrayList<JobDetails>();
            if (this.currentJob != null) {
                JobDetails details = this.currentJob;
                this.currentJob = null;
                details.job.cancel();
                cancelledJobs.add(details);
            }
            for (JobDetails details : this.pendingJobs) {
                details.job.cancel();
                cancelledJobs.add(details);
            }
            this.pendingJobs.clear();
            new Thread(){

                @Override
                public void run() {
                    SerialJobRunner.this.notifyJobsCancelled(cancelledJobs);
                }
            }.start();
        }
    }

    public void cancelJobs(Job ... jobs) {
        this.cancelJobs(Arrays.asList(jobs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobs(List<? extends Job> jobs) {
        Object object = this.lock;
        synchronized (object) {
            final ArrayList<JobDetails> cancelledJobs = new ArrayList<JobDetails>();
            for (Job job : jobs) {
                JobDetails details = this.findPendingJob(job);
                if (details != null) {
                    this.pendingJobs.remove(details);
                    details.job.cancel();
                    cancelledJobs.add(details);
                }
                if (this.currentJob == null || this.currentJob.job != job) continue;
                details = this.currentJob;
                this.currentJob = null;
                job.cancel();
                cancelledJobs.add(details);
            }
            new Thread(){

                @Override
                public void run() {
                    SerialJobRunner.this.notifyJobsCancelled(cancelledJobs);
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobDetails findPendingJob(Job job) {
        Object object = this.lock;
        synchronized (object) {
            for (JobDetails other : this.pendingJobs) {
                if (other.job != job) continue;
                return other;
            }
            return null;
        }
    }

    protected void postOnNotifyThread(Runnable runnable) {
        runnable.run();
    }

    protected void runOnNotifyThread(Runnable runnable) {
        runnable.run();
    }

    private void notifyJobCompleted(JobDetails job) {
        if (job.listener != null) {
            job.listener.jobCompleted(job.job);
        }
    }

    private void notifyJobsCancelled(final List<JobDetails> jobs) {
        this.postOnNotifyThread(new Runnable(){

            @Override
            public void run() {
                for (JobDetails job : jobs) {
                    if (job.listener == null) continue;
                    job.listener.jobCancelled(job.job);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runThread() {
        while (true) {
            JobDetails job;
            Object object = this.lock;
            synchronized (object) {
                if (this.pendingJobs.isEmpty()) {
                    this.thread = null;
                    return;
                }
                this.currentJob = job = this.pendingJobs.remove(0);
            }
            try {
                job.job.run();
            }
            catch (RuntimeException ex) {
                try {
                    Logger logger = AppComponents.getLogger(this.logtag);
                    logger.error("UNEXPECTED ERROR: " + ex.getMessage(), (Throwable)ex);
                    Object object2 = this.lock;
                    synchronized (object2) {
                        if (this.currentJob == job) {
                            this.currentJob = null;
                        }
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    this.runOnNotifyThread(new Runnable(job){
                        final /* synthetic */ JobDetails val$job;
                        {
                            this.val$job = jobDetails;
                        }

                        @Override
                        public void run() {
                            SerialJobRunner.this.finishCompletedJob(this.val$job);
                        }
                    });
                    throw throwable;
                }
            }
            this.runOnNotifyThread(new /* invalid duplicate definition of identical inner class */);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCompletedJob(JobDetails job) {
        boolean notify = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.currentJob == job) {
                notify = true;
                this.currentJob = null;
            }
        }
        if (notify) {
            this.notifyJobCompleted(job);
        }
    }

    private class JobDetails {
        public Job job;
        public int priority;
        public JobListener listener;

        public JobDetails(Job job, int priority, JobListener listener) {
            this.job = job;
            this.priority = priority;
            this.listener = listener;
        }
    }
}

